package jp.sourceforge.cfneo.at4ie2.api.browser.impl.ie;

import jp.sourceforge.cfneo.at4ie2.BTRuntimeError;
import jp.sourceforge.cfneo.at4ie2.api.browser.ConfirmDialog;

public class BTConfirmDialog implements ConfirmDialog {

	watij.dialogs.ConfirmDialog confirmDialog;

	BTConfirmDialog(watij.dialogs.ConfirmDialog confirmDialog) {
		this.confirmDialog = confirmDialog;
	}

	@Override
	public void clickCancel() {
		if (this.confirmDialog != null) {
			try {
				this.confirmDialog.cancel();
			} catch (Exception e) {
				throw new BTRuntimeError(e);
			}
		}
	}
	@Override
	public void clickOk() {
		if (this.confirmDialog != null) {
			try {
				this.confirmDialog.ok();
			} catch (Exception e) {
				throw new BTRuntimeError(e);
			}
		}
	}
	@Override
	public boolean exists() {
		if (this.confirmDialog == null) {
			return false;
		}
		try {
			return this.confirmDialog.exists();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public String getLabel() {
		if (this.confirmDialog == null) {
			return "";
		}
		try {
			return this.confirmDialog.text();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}

}
