package jp.sourceforge.cfneo.at4ie2.api.browser.impl.ie;

import org.apache.log4j.Logger;

import jp.sourceforge.cfneo.at4ie2.BTRuntimeError;
import jp.sourceforge.cfneo.at4ie2.api.browser.Button;

public class BTButton implements Button {

	Logger logger = Logger.getLogger(BTButton.class);
	watij.elements.Button button;

	BTButton(watij.elements.Button button) {
		this.button = button;
	}

	@Override
	public void click() {
		try {
			Thread t = new Thread(new Clicker(this.button));
			t.start();
			Thread.sleep(1500L);
			t = null;
			logger.debug("*** BTButton:Thread killed.");
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public String getValue() {
		try {
			return this.button.value();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public String getId() {
		try {
			return this.button.id();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public String getName() {
		try {
			return this.button.name();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	class Clicker implements Runnable {
		private watij.elements.Button button;
		public Clicker(watij.elements.Button button) {
			this.button = button;
		}
		public void run() {
			logger.debug("*** Clicker#run()");
			try {
				button.click();
			} catch (Exception e) {
				throw new BTRuntimeError(e);
			}
		}
	}
	@Override
	public boolean exists() {
		try {
			return this.button.exists();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}

}
