package misc;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import jxl.Sheet;
import jxl.Workbook;

import org.apache.log4j.Logger;
import org.junit.Test;

/**
 * JExcelAPÎꂱẴׂ݂eXgNXB
 * @author imaitakafumi
 *
 */
public class JExcelTest {

	Logger logger = Logger.getLogger(JExcelTest.class);
	String path = "src/test/resources/exceltest_wikipedia_jp.xls";

	@Test
	public void test1_ǂݍݗK1_\s̊mF() {
		try {
			Workbook book = Workbook.getWorkbook(new File(this.path));
			Sheet sheet = book.getSheet("TestCase");
			assertEquals(7, sheet.getRows());
			assertEquals(3, sheet.getColumns());
			assertEquals("COMMAND",	sheet.getCell(0, 0).getContents());
			assertEquals("TARGET",	sheet.getCell(1, 0).getContents());
			assertEquals("VALUE",	sheet.getCell(2, 0).getContents());
			book.close();
		} catch(Exception e) {
			e.printStackTrace();
			fail();
		}
	}
	@Test
	public void test1_ǂݍݗK2_P[Xe̊mF() {
		try {
			Workbook book = Workbook.getWorkbook(new File(this.path));
			Sheet sheet = book.getSheet("TestCase");
			List<TestCaseRow4Test> exp = this.getExpectedValue();
			for (int row = 0; row < sheet.getRows(); row++) {
				logger.debug("[" + row + "]");
				TestCaseRow4Test bean = exp.get(row);
				assertEquals(bean.command,	sheet.getCell(0, row).getContents());
				assertEquals(bean.target,	sheet.getCell(1, row).getContents());
				assertEquals(bean.value,	sheet.getCell(2, row).getContents());
				System.out.println(bean.toString());
			}
			book.close();
		} catch(Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	private List<TestCaseRow4Test> getExpectedValue() {
		List<TestCaseRow4Test> ret = new ArrayList<TestCaseRow4Test>();
		TestCaseRow4Test bean;
		// 0
		bean = new TestCaseRow4Test();
		bean.command = "COMMAND";
		bean.target = "TARGET";
		bean.value = "VALUE";
		ret.add(bean);
		// 1
		bean = new TestCaseRow4Test();
		bean.command = "open";
		bean.target = "http://ja.wikipedia.org/wiki/%E3%83%A1%E3%82%A4%E3%83%B3%E3%83%9A%E3%83%BC%E3%82%B8";
		bean.value = "";
		ret.add(bean);
		// 2
		bean = new TestCaseRow4Test();
		bean.command = "screenshot";
		bean.target = "src/test/resources/csvtest_wikipedia_jp_1.png";
		bean.value = "";
		ret.add(bean);
		// 3
		bean = new TestCaseRow4Test();
		bean.command = "type";
		bean.target = "name=\"search\"";
		bean.value = "΃Pa";
		ret.add(bean);
		// 4
		bean = new TestCaseRow4Test();
		bean.command = "screenshot";
		bean.target = "src/test/resources/csvtest_wikipedia_jp_2.png";
		bean.value = "";
		ret.add(bean);
		// 5
		bean = new TestCaseRow4Test();
		bean.command = "click";
		bean.target = "name=\"go\"";
		bean.value = "";
		ret.add(bean);
		// 6
		bean = new TestCaseRow4Test();
		bean.command = "screenshot";
		bean.target = "src/test/resources/csvtest_wikipedia_jp_3.png";
		bean.value = "";
		ret.add(bean);

		return ret;
	}

	class TestCaseRow4Test {
		public String command;
		public String target;
		public String value;

		public String toString() {
			return "command=" + this.command
				+ " target=" + this.target + " value=" + this.value;
		}
	}

}
