package jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker;

import static org.junit.Assert.assertTrue;
import jp.sourceforge.cfneo.at4ie.api.ActionCommandEnum;
import jp.sourceforge.cfneo.at4ie.api.impl.DefaultTestCase;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.AT4IEInternetExplorer;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.DefaultContext;

import org.apache.log4j.Logger;
import org.junit.Test;

/**
 * WaitInvoker
 * @author imaitakafumi
 *
 */
public class AT4IEWaitInvokerTest {

	Logger logger = Logger.getLogger(AT4IEWaitInvokerTest.class);

	/**
	 * {̃eXgB
	 * ʏ̐l^B
	 */
	@Test
	public void testInvoke_1() {
		DefaultContext context = new DefaultContext();
		AT4IEWaitInvoker invoker = new AT4IEWaitInvoker(context, new AT4IEInternetExplorer());
		DefaultTestCase testcase = new DefaultTestCase(
				new DefaultContext(), ActionCommandEnum.WAIT, "2", null);
		long before = System.currentTimeMillis();
		invoker.invoke(testcase);
		long after = System.currentTimeMillis();
		logger.debug("time=" + (after - before) + " before=" + before + "/after=" + after);
		assertTrue(before < after);
	}

	/**
	 * {̃eXgB
	 * ʏ̐l^B
	 */
	@Test
	public void testInvoke_2() {
		DefaultContext context = new DefaultContext();
		AT4IEWaitInvoker invoker = new AT4IEWaitInvoker(context, new AT4IEInternetExplorer());
		DefaultTestCase testcase = new DefaultTestCase(
				new DefaultContext(), ActionCommandEnum.WAIT, "20", null);
		long before = System.currentTimeMillis();
		invoker.invoke(testcase);
		long after = System.currentTimeMillis();
		logger.debug("time=" + (after - before) + " before=" + before + "/after=" + after);
		assertTrue(before < after);
	}

	/**
	 * {̃eXgB
	 * 0^B
	 */
	@Test
	public void testInvoke_3() {
		DefaultContext context = new DefaultContext();
		AT4IEWaitInvoker invoker = new AT4IEWaitInvoker(context, new AT4IEInternetExplorer());
		DefaultTestCase testcase = new DefaultTestCase(
				new DefaultContext(), ActionCommandEnum.WAIT, "0", null);
		long before = System.currentTimeMillis();
		invoker.invoke(testcase);
		long after = System.currentTimeMillis();
		logger.debug("time=" + (after - before) + " before=" + before + "/after=" + after);
		assertTrue(before == after);
	}

	/**
	 * {̃eXgB
	 * ^B
	 */
	@Test
	public void testInvoke_4() {
		DefaultContext context = new DefaultContext();
		AT4IEWaitInvoker invoker = new AT4IEWaitInvoker(context, new AT4IEInternetExplorer());
		DefaultTestCase testcase = new DefaultTestCase(
				new DefaultContext(), ActionCommandEnum.WAIT, "0", null);
		long before = System.currentTimeMillis();
		invoker.invoke(testcase);
		long after = System.currentTimeMillis();
		logger.debug("time=" + (after - before) + " before=" + before + "/after=" + after);
		assertTrue(before == after);
	}

	/**
	 * {̃eXgB
	 * ԕ\L̕^B
	 */
	@Test
	public void testInvoke_5() {
		DefaultContext context = new DefaultContext();
		AT4IEWaitInvoker invoker = new AT4IEWaitInvoker(context, new AT4IEInternetExplorer());
		DefaultTestCase testcase = new DefaultTestCase(
				new DefaultContext(), ActionCommandEnum.WAIT, "0:02", null);
		long before = System.currentTimeMillis();
		invoker.invoke(testcase);
		long after = System.currentTimeMillis();
		logger.debug("time=" + (after - before) + " before=" + before + "/after=" + after);
		assertTrue(before < after);
	}

	/**
	 * {̃eXgB
	 * 󕶎^B
	 */
	@Test
	public void testInvoke_6() {
		DefaultContext context = new DefaultContext();
		AT4IEWaitInvoker invoker = new AT4IEWaitInvoker(context, new AT4IEInternetExplorer());
		DefaultTestCase testcase = new DefaultTestCase(
				new DefaultContext(), ActionCommandEnum.WAIT, "", null);
		long before = System.currentTimeMillis();
		invoker.invoke(testcase);
		long after = System.currentTimeMillis();
		logger.debug("time=" + (after - before) + " before=" + before + "/after=" + after);
		assertTrue(before == after);
	}

	/**
	 * {̃eXgB
	 * null^B
	 */
	@Test
	public void testInvoke_7() {
		DefaultContext context = new DefaultContext();
		AT4IEWaitInvoker invoker = new AT4IEWaitInvoker(context, new AT4IEInternetExplorer());
		DefaultTestCase testcase = new DefaultTestCase(
				new DefaultContext(), ActionCommandEnum.WAIT, null, null);
		long before = System.currentTimeMillis();
		invoker.invoke(testcase);
		long after = System.currentTimeMillis();
		logger.debug("time=" + (after - before) + " before=" + before + "/after=" + after);
		assertTrue(before == after);
	}

}
