package jp.sourceforge.cfneo.at4ie.api.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;
import jp.sourceforge.cfneo.at4ie.api.ActionCommandEnum;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.DefaultContext;

import org.junit.Test;

/**
 * DefaultTestCaseȂтɁASuperClassłTestCasẽeXgB
 * @author imaitakafumi
 *
 */
/**
 * @author imaitakafumi
 *
 */
public class DefaultTestCaseTest {

	/**
	 * RXgN^̃eXgB
	 * ł炨B
	 */
	@Test
	public void testDefaultTestCase_1() {
		try {
			new DefaultTestCase(
					new DefaultContext(),
					ActionCommandEnum.ACTION_ANSWER_ON_NEXT_PROMPT
					, "", "");
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}
	/**
	 * RXgN^̃eXgB
	 * p[^nullݒ肵Ă݂B
	 */
	@Test
	public void testDefaultTestCase_2() {
		try {
			new DefaultTestCase(
					null, null, null, null);
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	/**
	 * getElementValue()̃eXgB
	 * ƃp[^^ꂽCX^XŎsB
	 */
	@Test
	public void testGetElementValue_1() {
		try {
			DefaultTestCase testcase = new DefaultTestCase(
					new DefaultContext(),
					ActionCommandEnum.ACTION_ANSWER_ON_NEXT_PROMPT
					, "aaa", "bbb");
			assertEquals("aaa", testcase.getElementValue());
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	/**
	 * getElementValue()̃eXgB
	 * _uENH[e[VɈ͂܂ꂽZbgꂽCX^XŎsB
	 */
	@Test
	public void testGetElementValue_2() {
		try {
			DefaultTestCase testcase = new DefaultTestCase(
					new DefaultContext(),
					ActionCommandEnum.ACTION_ANSWER_ON_NEXT_PROMPT
					, "\"aaa\"", "\"bbb\"");
			assertEquals("aaa", testcase.getElementValue());
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	/**
	 * getElementValue()̃eXgB
	 * ElementLocatorŏłȂCR[ƃ_uENH[e[Vgꂽ
	 * ꂽCX^XŎsB
	 */
	@Test
	public void testGetElementValue_3() {
		try {
			DefaultTestCase testcase = new DefaultTestCase(
					new DefaultContext(),
					ActionCommandEnum.ACTION_ANSWER_ON_NEXT_PROMPT
					, "aaa=\"aaa\"", null);
			assertEquals("aaa=\"aaa\"", testcase.getElementValue());
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	/**
	 * getElementValue()̃eXgB
	 * ElementLocatorŏ\ȕōꂽCX^XŎsB
	 */
	@Test
	public void testGetElementValue_4() {
		try {
			DefaultTestCase testcase = new DefaultTestCase(
					new DefaultContext(),
					ActionCommandEnum.ACTION_ANSWER_ON_NEXT_PROMPT
					, "id=\"aaa\"", null);
			assertEquals("aaa", testcase.getElementValue());
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	/**
	 * getElementValue()̃eXgB
	 * nullŐꂽCX^XŎsB
	 */
	@Test
	public void testGetElementValue_5() {
		try {
			DefaultTestCase testcase = new DefaultTestCase(
					new DefaultContext(),
					ActionCommandEnum.ACTION_ANSWER_ON_NEXT_PROMPT
					, null, null);
			assertEquals(null, testcase.getElementValue());
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}


	/**
	 * getElementValue()̃eXgB
	 * targetnullAvalueɕ񂪎w肳ꂽCX^XŎsB
	 */
	@Test
	public void testGetElementValue_6() {
		try {
			DefaultTestCase testcase = new DefaultTestCase(
					new DefaultContext(),
					ActionCommandEnum.ACTION_ANSWER_ON_NEXT_PROMPT
					, null, "bbb");
			assertEquals(null, testcase.getElementValue());
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	/**
	 * toString()̃eXgB
	 * nullŐCX^XŎsB
	 */
	@Test
	public void testToString_1() {
		try {
			DefaultTestCase testcase = new DefaultTestCase(
					null, null , null, null);
			assertEquals(
					" command=[null] target=[null] value=[null] elementValue=[null]",
					testcase.toString());
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	/**
	 * toString()̃eXgB
	 * ʏ̃p[^^ꂽCX^XŎsB
	 */
	public void testToString_2() {
		try {
			DefaultTestCase testcase = new DefaultTestCase(
					new DefaultContext(),
					ActionCommandEnum.ACTION_ANSWER_ON_NEXT_PROMPT
					, "aaa", "bbb");
			assertEquals(
					" command=[answerOnNextPrompt] target=[aaa] value=[bbb] elementValue=[aaa]",
					testcase.toString());
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	/**
	 * toString()̃eXgB
	 * ElementLocationpꂽCX^XŎsB
	 */
	public void testToString_3() {
		try {
			DefaultTestCase testcase = new DefaultTestCase(
					new DefaultContext(),
					ActionCommandEnum.ACTION_ANSWER_ON_NEXT_PROMPT
					, "id=test", "123");
			assertEquals(
					" command=[answerOnNextPrompt] target=[id=test] value=[123] elementValue=[test]",
					testcase.toString());
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	/**
	 * toString()̃eXgB
	 * ElementLocatorŏłȂpꂽCX^XŎsB
	 */
	public void testToString_4() {
		try {
			DefaultTestCase testcase = new DefaultTestCase(
					new DefaultContext(),
					ActionCommandEnum.ACTION_ANSWER_ON_NEXT_PROMPT
					, "aaa=\"bbb\"", "test");
			assertEquals(
					" command=[] target=[] value=[] elementValue=[]",
					testcase.toString());
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

}
