package jp.sourceforge.cfneo.at4ie.impl.csv;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

import jp.sourceforge.cfneo.at4ie.api.AT4IEFileContentsException;
import jp.sourceforge.cfneo.at4ie.api.AT4IEFileException;
import jp.sourceforge.cfneo.at4ie.api.AT4IERuntimeException;
import jp.sourceforge.cfneo.at4ie.api.Context;
import jp.sourceforge.cfneo.at4ie.api.FileValidator;

/**
 * CSVt@ČNXB
 * @author imaitakafumi
 *
 */
public class CsvValidator implements FileValidator {

	private Context context;

	/**
	 * RXgN^B
	 * @param context
	 */
	public CsvValidator(Context context) {
		this.context = context;
	}

	@Override
	public void validate(String filepath) throws AT4IEFileException,
			AT4IEFileContentsException {
		CsvContext setting = (CsvContext) this.context;
		try {
			BufferedReader br = new BufferedReader(new FileReader(filepath));
			String line = null;
			int row = 0;
			while ((line = br.readLine()) != null) {
				if (line.indexOf(setting.getDelimiter()) == 0) {
					throw new AT4IEFileContentsException("No column. row=" + row);
				}
				row++;
			}
			br.close();
		} catch (IOException e) {
			throw new AT4IERuntimeException(e);
		}
	}

}
