package jp.sourceforge.cfneo.at4ie.impl.csv;

import jp.sourceforge.cfneo.at4ie.api.ActionCommandEnum;
import jp.sourceforge.cfneo.at4ie.api.Context;
import jp.sourceforge.cfneo.at4ie.api.TestCase;
import jp.sourceforge.cfneo.at4ie.impl.xls.TestCaseFormatEnum;
import jp.sourceforge.cfneo.at4ie.utils.LocatorUtil;

import org.apache.log4j.Logger;

/**
 * CSVpeXgP[XNXB
 * @author imaitakafumi
 *
 */
public class CsvTestCase extends TestCase {

	static Logger logger = Logger.getLogger(CsvTestCase.class);

	/**
	 * RXgN^B
	 * @param context
	 * @param line
	 * @return
	 */
	public static CsvTestCase createTestCase(Context context, String line) {
		logger.debug("line=" + line);
		String[] params = line.split(",");
		logger.debug("line.length=" + params.length);
		String target = "";
		String value = "";
		if (params.length > 1) {
			target = LocatorUtil.deleteDoubleQuotation(params[TestCaseFormatEnum.TARGET.toIntValue()].trim());
		}
		if (params.length > 2) {
			value = LocatorUtil.deleteDoubleQuotation(params[TestCaseFormatEnum.VALUE.toIntValue()]);
		}
		return new CsvTestCase(
				context,
				ActionCommandEnum.get(params[TestCaseFormatEnum.COMMAND.toIntValue()].trim()),
				target,
				value);
	}

	/**
	 * RXgN^B
	 * @param context
	 * @param action
	 * @param target
	 * @param value
	 */
	public CsvTestCase(
			Context context,
			ActionCommandEnum action,
			String target,
			String value) {
		super(context, action, target, value);
	}

}
