package jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker;

import jp.sourceforge.cfneo.at4ie.api.AT4IEAssertException;
import jp.sourceforge.cfneo.at4ie.api.AT4IERuntimeException;
import jp.sourceforge.cfneo.at4ie.api.Context;
import jp.sourceforge.cfneo.at4ie.api.ElementLocatorEnum;
import jp.sourceforge.cfneo.at4ie.api.Invoker;
import jp.sourceforge.cfneo.at4ie.api.TargetBrowser;
import jp.sourceforge.cfneo.at4ie.api.TestCase;
import jp.sourceforge.cfneo.at4ie.utils.LocatorUtil;

/**
 * command=typeInvokerB<br />
 * y[W̃eLXgւ̓͂sB
 * @author imaitakafumi
 *
 */
public class TypeInvoker extends Invoker {

	/**
	 * RXgN^B
	 * @param context
	 * @param browser
	 */
	public TypeInvoker(Context context, TargetBrowser browser) {
		super(context, browser);
	}

	@Override
	public void invoke(TestCase testCase) throws AT4IEAssertException {
		try {
			ElementLocatorEnum elem = LocatorUtil.getElementLocatorEnum(testCase.getTarget());
			switch (elem) {
			case DOM:
				break;
			case ID:
				super.getBrowser().typeById(
						LocatorUtil.getLocatorValue(testCase.getTarget()),
						testCase.getValue());
				break;
			case IDENTIFIER:
				break;
			case LINK:
				break;
			case NAME:
				super.getBrowser().typeByName(
						LocatorUtil.getLocatorValue(testCase.getTarget()),
						testCase.getValue());
				break;
			case XPATH:
				break;
			case OTHER:
				break;
			}
		} catch (Exception e) {
			throw new AT4IERuntimeException(e);
		}
	}

}
