package jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker;

import jp.sourceforge.cfneo.at4ie.api.AT4IEAssertException;
import jp.sourceforge.cfneo.at4ie.api.AT4IERuntimeException;
import jp.sourceforge.cfneo.at4ie.api.Context;
import jp.sourceforge.cfneo.at4ie.api.ElementLocatorEnum;
import jp.sourceforge.cfneo.at4ie.api.Invoker;
import jp.sourceforge.cfneo.at4ie.api.TargetBrowser;
import jp.sourceforge.cfneo.at4ie.api.TestCase;
import jp.sourceforge.cfneo.at4ie.utils.LocatorUtil;

import org.apache.log4j.Logger;

/**
 * command=storeTextInvokerB<br />
 * targetɎw肳ꂽϐvalueŎw肳ꂽUIR|[lg̒lۑB
 * @author imaitakafumi
 *
 */
public class StoreTextInvoker extends Invoker {

	Logger logger = Logger.getLogger(StoreTextInvoker.class);

	/**
	 * RXgN^B
	 * @param context
	 * @param browser
	 */
	public StoreTextInvoker(Context context, TargetBrowser browser) {
		super(context, browser);
	}

	@Override
	public void invoke(TestCase testCase) throws AT4IEAssertException {
		logger.debug("ClickInvoker#invoke testCase=" + testCase.toString());
		try {
			ElementLocatorEnum elem = LocatorUtil
					.getElementLocatorEnum(testCase.getTarget());
			logger.debug("ClickInvoker#invoke elem=" + elem.toString());
			switch (elem) {
			case DOM:
				break;
			case ID:
				this.getContext().setValue(testCase.getValue(),
						this.getBrowser().getTextById(testCase.getElementValue()));
				break;
			case IDENTIFIER:
				break;
			case LINK:
				break;
			case NAME:
				this.getContext().setValue(testCase.getValue(),
						this.getBrowser().getTextByName(testCase.getElementValue()));
				break;
			case XPATH:
				break;
			case VALUE:
				break;
			case OTHER:
				break;
			}
		} catch (Exception e) {
			throw new AT4IERuntimeException(e);
		}
	}

}
