package jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker;

import jp.sourceforge.cfneo.at4ie.api.AT4IEAssertException;
import jp.sourceforge.cfneo.at4ie.api.Context;
import jp.sourceforge.cfneo.at4ie.api.Invoker;
import jp.sourceforge.cfneo.at4ie.api.TargetBrowser;
import jp.sourceforge.cfneo.at4ie.api.TestCase;

import org.apache.log4j.Logger;

/**
 * command=assertTitleInvokerB<br />
 * ݂̃y[WE^Cg؂B
 * @author imaitakafumi
 *
 */
public class AssertTitleInvoker extends Invoker {

	Logger logger = Logger.getLogger(AssertTitleInvoker.class);

	/**
	 * RXgN^B
	 * @param context
	 * @param browser
	 */
	public AssertTitleInvoker(Context context, TargetBrowser browser) {
		super(context, browser);
	}

	@Override
	public void invoke(TestCase testCase) throws AT4IEAssertException {
		String expected = testCase.getElementValue();
		String actual = this.getBrowser().getScreenTitle();
		logger.debug("AssertTitleInvoker#invoke testCase=" + testCase.toString()
				+ " expected=[" + expected + "]/actual=[" + actual + "]");
		if (expected.equals(actual) == false) {
			throw new AT4IEAssertException(expected, actual);
		}
	}

}
