package jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker;

import java.util.Map;

import jp.sourceforge.cfneo.at4ie.api.AT4IEAssertException;
import jp.sourceforge.cfneo.at4ie.api.Context;
import jp.sourceforge.cfneo.at4ie.api.ElementLocatorEnum;
import jp.sourceforge.cfneo.at4ie.api.Invoker;
import jp.sourceforge.cfneo.at4ie.api.TargetBrowser;
import jp.sourceforge.cfneo.at4ie.api.TestCase;
import jp.sourceforge.cfneo.at4ie.utils.LocatorUtil;

import org.apache.log4j.Logger;

/**
 * hbv_EɂSĂoption Label J}؂̃XgƂČ؂܂B
 * J}"\,"ƂăGXP[v܂B
 * @author imaitakafumi
 *
 */
public class AssertSelectedOptionInvoker extends Invoker {

	Logger logger = Logger.getLogger(AssertSelectedOptionInvoker.class);

	/**
	 * RXgN^B
	 * @param context
	 * @param browser
	 */
	public AssertSelectedOptionInvoker(Context context, TargetBrowser browser) {
		super(context, browser);
	}

	@Override
	public void invoke(TestCase testCase) throws AT4IEAssertException {
		ElementLocatorEnum elem = LocatorUtil.getElementLocatorEnum(testCase.getTarget());
		String[] expected = testCase.getValue().split("\\\\,");
		logger.debug("expected=" + expected);
		Map<String, String> actual = null;
		logger.debug("elem=" + elem.toString());
		switch (elem) {
		case DOM:
			break;
		case ID:
			actual = super.getBrowser().getSelectListById(testCase.getElementValue());
		case IDENTIFIER:
			break;
		case LINK:
			break;
		case NAME:
			actual = super.getBrowser().getSelectListByName(testCase.getElementValue());
			break;
		case XPATH:
			break;
		case VALUE:
			break;
		case OTHER:
			break;
		}
		boolean illegal = false;
		if (expected.length != actual.size()) {
			illegal = true;
		}
		for (String s: expected) {
			if (actual.containsKey(s) == false) {
				illegal = true;
				break;
			}
		}
		if (illegal) {
			StringBuffer sb = new StringBuffer();
			for (String s: expected) {
				sb.append(s);
				sb.append(",");
			}
			throw new AT4IEAssertException(
					sb.toString().substring(0, sb.length() - 1),
					actual.toString());
		}
	}

}
