package jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker;

import java.lang.reflect.Constructor;

import jp.sourceforge.cfneo.at4ie.api.AT4IEAssertException;
import jp.sourceforge.cfneo.at4ie.api.AT4IERuntimeException;
import jp.sourceforge.cfneo.at4ie.api.Context;
import jp.sourceforge.cfneo.at4ie.api.Invoker;
import jp.sourceforge.cfneo.at4ie.api.InvokerFactory;
import jp.sourceforge.cfneo.at4ie.api.TargetBrowser;
import jp.sourceforge.cfneo.at4ie.api.TestCase;

/**
 * command=injectionInvokerB<br />
 * w肳ꂽInvoker̃TuNX[hAsB
 * @author imaitakafumi
 *
 */
public class AT4IEInjectionInvoker extends Invoker {

	/**
	 * RXgN^B
	 * @param context
	 * @param browser
	 */
	public AT4IEInjectionInvoker(Context context, TargetBrowser browser) {
		super(context, browser);
	}

	@SuppressWarnings("unchecked")
	@Override
	public void invoke(TestCase testCase) throws AT4IEAssertException {
		try {
			Class c = (Class<Invoker>) Class.forName(testCase.getTarget());
			Class[] paramType = {InvokerFactory.class, TargetBrowser.class};
			Constructor<Invoker> constructor = c.getConstructor(paramType);
			Object[] params = {this.getContext().getInvokerFactory(), this.getBrowser()};
			Invoker invoker = (Invoker) constructor.newInstance(params);
			invoker.invoke(testCase);
		} catch (Exception e) {
			throw new AT4IERuntimeException(e);
		}
	}

}
