/*
 * Decompiled with CFR 0.152.
 */
package watij.runtime.ie;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.NativeResourceCollector;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt;
import com.jniwrapper.win32.automation.IDispatch;
import com.jniwrapper.win32.automation.OleMessageLoop;
import com.jniwrapper.win32.automation.types.BStr;
import com.jniwrapper.win32.automation.types.Variant;
import com.jniwrapper.win32.com.IUnknown;
import com.jniwrapper.win32.com.types.ClsCtx;
import com.jniwrapper.win32.ie.IEAutomation;
import com.jniwrapper.win32.mshtml.IHTMLDocument2;
import com.jniwrapper.win32.mshtml.impl.IHTMLDocument2Impl;
import com.jniwrapper.win32.shdocvw.IShellWindows;
import com.jniwrapper.win32.shdocvw.IWebBrowser2;
import com.jniwrapper.win32.shdocvw.ShellWindows;
import com.jniwrapper.win32.shdocvw.impl.IWebBrowser2Impl;
import com.jniwrapper.win32.ui.SystemParametersInfo;
import com.jniwrapper.win32.ui.User32;
import com.jniwrapper.win32.ui.Wnd;
import java.util.List;
import watij.iwshruntimelibrary.IWshShell3;
import watij.iwshruntimelibrary.WshShell;
import watij.runtime.NoMatchingWindowFoundException;
import watij.runtime.ie.IE;
import watij.time.Ready;
import watij.time.WaiterImpl;
import watij.utilities.Debug;
import watij.utilities.IUnknownBinder;
import watij.utilities.IUnknownFactory;
import watij.utilities.StringUtils;

public class IEUtil {
    protected static final String DIALOG_CLASSNAME = "#32770";

    public static void debug(String s) {
        Debug.getInstance().println(s);
    }

    public static IUnknown bind(OleMessageLoop oleMessageLoop, IUnknownFactory iUnknownFactory) throws Exception {
        return new IUnknownBinder(oleMessageLoop).bind(iUnknownFactory);
    }

    public static void stopAutoGC() throws Exception {
        NativeResourceCollector.getInstance().stop();
    }

    public static void startAutoGC() throws Exception {
        NativeResourceCollector.getInstance().start();
    }

    public static void switchToThisWindow(Wnd wnd) {
        SystemParametersInfo.systemParametersInfo((UInt)new UInt(8193L), (UInt)new UInt(0L), (Pointer)new Pointer((Parameter)new Pointer.Void()), (UInt)new UInt(3L));
        Function showAsync = User32.getInstance().getFunction("ShowWindowAsync");
        showAsync.invoke(null, (Parameter)wnd, (Parameter)new Int((long)Wnd.ShowWindowCommand.SHOWNORMAL.getValue()));
        wnd.setForeground();
        SystemParametersInfo.systemParametersInfo((UInt)new UInt(8193L), (UInt)new UInt(200000L), (Pointer)new Pointer((Parameter)new Pointer.Void()), (UInt)new UInt(3L));
    }

    protected static IWshShell3 IWshShell3(OleMessageLoop oleMessageLoop) throws Exception {
        return (IWshShell3)IEUtil.bind(oleMessageLoop, new IUnknownFactory(){

            public IUnknown create() throws Exception {
                return WshShell.create((ClsCtx)ClsCtx.INPROC_SERVER);
            }
        });
    }

    public static void sendKeys(String title, final String keys, boolean blocking, OleMessageLoop oleMessageLoop) throws Exception {
        if (blocking) {
            IWshShell3 iWshShell3 = IEUtil.IWshShell3(oleMessageLoop);
            Thread.sleep(200L);
            IEUtil.sendKeys(iWshShell3, keys);
            Thread.sleep(200L);
        } else {
            OleMessageLoop sendKeysMessageLoop = new OleMessageLoop("sendKeys");
            sendKeysMessageLoop.doStart();
            sendKeysMessageLoop.doInvokeLater(new Runnable(){

                public void run() {
                    try {
                        IWshShell3 iWshShell3 = WshShell.create((ClsCtx)ClsCtx.INPROC_SERVER);
                        Thread.sleep(200L);
                        IEUtil.sendKeys(iWshShell3, keys);
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private static void sendKeys(IWshShell3 iWshShell3, String keys) throws Exception {
        iWshShell3.sendKeys(new BStr(keys), new Variant(true));
    }

    protected static IEAutomation attach(final String titleOrUrl, final boolean url) throws Exception {
        IEAutomation ieAutomation = new IEAutomation();
        OleMessageLoop oleMessageLoop = ieAutomation.getOleMessageLoop();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class AttachBrowserAction
        implements BrowserAction {
            IWebBrowser2 browser = null;

            AttachBrowserAction() {
            }

            @Override
            public boolean perform(IWebBrowser2 iWebBrowser2, OleMessageLoop oleMessageLoop) throws Exception {
                Debug.getInstance().println("url=" + iWebBrowser2.getLocationURL().getValue());
                if (url && StringUtils.matchesOrEquals(titleOrUrl, iWebBrowser2.getLocationURL().getValue())) {
                    Debug.getInstance().println("Found Visible Browser By URL**");
                    this.browser = iWebBrowser2;
                    return false;
                }
                IDispatch document = (IDispatch)oleMessageLoop.bindObject((IUnknown)iWebBrowser2.getDocument());
                IHTMLDocument2 ihtmlDocument2 = (IHTMLDocument2)oleMessageLoop.bindObject((IUnknown)new IHTMLDocument2Impl((IUnknown)document));
                Debug.getInstance().println("title=" + ihtmlDocument2.getTitle().getValue());
                if (StringUtils.matchesOrEquals(titleOrUrl, ihtmlDocument2.getTitle().getValue())) {
                    Debug.getInstance().println("Found Visible Browser By Title**");
                    this.browser = iWebBrowser2;
                    return false;
                }
                return true;
            }
        }
        AttachBrowserAction attachBrowserAction = new AttachBrowserAction();
        IEUtil.executeOnAllBrowsers(attachBrowserAction, oleMessageLoop);
        if (attachBrowserAction.browser == null) {
            throw new NoMatchingWindowFoundException("Could not find browser");
        }
        ieAutomation.close();
        ieAutomation.setBrowser(attachBrowserAction.browser);
        return ieAutomation;
    }

    protected static void executeOnAllBrowsers(BrowserAction browserAction, OleMessageLoop oleMessageLoop) throws Exception {
        IShellWindows iShellWindows = (IShellWindows)IEUtil.bind(oleMessageLoop, new IUnknownFactory(){

            public IUnknown create() throws Exception {
                return ShellWindows.create((ClsCtx)ClsCtx.INPROC_SERVER);
            }
        });
        int count = (int)iShellWindows.getCount().getValue();
        Debug.getInstance().println("Number Browsers Found by ShellWindows = " + count);
        for (int i = count - 1; i >= 0; --i) {
            IWebBrowser2 browser;
            Debug.getInstance().println("Trying Browser " + i);
            IDispatch item = (IDispatch)oleMessageLoop.bindObject((IUnknown)iShellWindows.item(new Variant(i)));
            if (item.isNull()) {
                browser = null;
                continue;
            }
            browser = (IWebBrowser2)oleMessageLoop.bindObject((IUnknown)new IWebBrowser2Impl((IUnknown)item));
            try {
                Debug.getInstance().println("browser name=" + browser.getName().toString());
                if (!StringUtils.matchesOrContains(IE.TITLE, browser.getName().toString())) continue;
                IDispatch document = (IDispatch)oleMessageLoop.bindObject((IUnknown)browser.getDocument());
                oleMessageLoop.bindObject((IUnknown)new IHTMLDocument2Impl((IUnknown)document));
            }
            catch (Throwable t) {
                Debug.handleException(t);
                browser = null;
                continue;
            }
            if (!browserAction.perform(browser, oleMessageLoop)) break;
        }
    }

    public static void closeAllBrowsers() throws Exception {
        IEUtil.closeAllDialogs();
        OleMessageLoop oleMessageLoop = OleMessageLoop.getInstance();
        IEUtil.executeOnAllBrowsers(new BrowserAction(){

            public boolean perform(IWebBrowser2 iWebBrowser2, OleMessageLoop oleMessageLoop) throws Exception {
                iWebBrowser2.quit();
                return true;
            }
        }, oleMessageLoop);
    }

    public static int browserCount() throws Exception {
        OleMessageLoop oleMessageLoop = OleMessageLoop.getInstance();
        class CountBrowserAction
        implements BrowserAction {
            int count = 0;

            CountBrowserAction() {
            }

            public boolean perform(IWebBrowser2 iWebBrowser2, OleMessageLoop oleMessageLoop) throws Exception {
                ++this.count;
                return true;
            }
        }
        CountBrowserAction countBrowserAction = new CountBrowserAction();
        IEUtil.executeOnAllBrowsers(countBrowserAction, oleMessageLoop);
        return countBrowserAction.count;
    }

    protected static void debugWndChildren(Wnd wnd, String prefix) {
        if (Debug.isDebug()) {
            prefix = prefix + "_childWindow";
            List children = wnd.getChildWindows();
            for (int i = 0; i < children.size(); ++i) {
                IEUtil.debugWnd((Wnd)children.get(i), prefix);
            }
        }
    }

    protected static void debugWnd(Wnd wnd, String prefix) {
        if (Debug.isDebug()) {
            Debug.getInstance().println(prefix + "_windowClassName = " + wnd.getWindowClassName());
            Debug.getInstance().println(prefix + "_windowText = " + wnd.getWindowText());
            Debug.getInstance().println(prefix + "_isWindow = " + wnd.isWindow());
        }
    }

    protected static Wnd waitDialogWnd(final Wnd startWnd, final String windowClassName, final String windowText) throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WindowReady
        implements Ready {
            Wnd wnd;

            WindowReady() {
            }

            @Override
            public boolean isReady() throws Exception {
                this.wnd = Wnd.findWindowEx((Wnd)startWnd, (String)windowClassName, (String)windowText);
                IEUtil.debugWnd(this.wnd, "findByStartWind");
                return this.wnd.isWindow();
            }

            @Override
            public String getNotReadyReason() {
                return "Could not find Dialog with windowClassName = " + windowClassName + " windowText=" + windowText;
            }

            public Wnd wnd() {
                return this.wnd;
            }
        }
        WindowReady windowReady = new WindowReady();
        new WaiterImpl(10000L, 200L).waitUntil(windowReady);
        Wnd wnd = windowReady.wnd();
        return wnd;
    }

    protected static Wnd waitDialogWnd(String title) throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WindowReady
        implements Ready {
            Wnd wnd;
            final /* synthetic */ String val$title;

            WindowReady(String string) {
                this.val$title = string;
            }

            @Override
            public boolean isReady() throws Exception {
                this.wnd = Wnd.findWindow((String)IEUtil.DIALOG_CLASSNAME, (String)this.val$title);
                IEUtil.debugWnd(this.wnd, "findByTitle");
                return this.wnd.isWindow();
            }

            @Override
            public String getNotReadyReason() {
                return "Could not find Dialog with title = " + this.val$title;
            }

            public Wnd wnd() {
                return this.wnd;
            }
        }
        WindowReady windowReady = new WindowReady(title);
        new WaiterImpl(10000L, 200L).waitUntil(windowReady);
        Wnd wnd = windowReady.wnd();
        IEUtil.switchToThisWindow(wnd);
        Debug.getInstance().println("Found through findByTitle");
        return wnd;
    }

    protected static Wnd waitDialogWnd(final String title, final String childClassName, final String childText) throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WindowReady
        implements Ready {
            Wnd wnd;

            WindowReady() {
            }

            @Override
            public boolean isReady() throws Exception {
                this.wnd = IEUtil.findDialogWnd(title, childClassName, childText);
                return this.wnd != null;
            }

            @Override
            public String getNotReadyReason() {
                return "Could not find Dialog with title=" + title + " childClassName=" + childClassName + " childText=" + childText;
            }

            public Wnd wnd() {
                return this.wnd;
            }
        }
        WindowReady windowReady = new WindowReady();
        new WaiterImpl(10000L, 200L).waitUntil(windowReady);
        Wnd wnd = windowReady.wnd();
        IEUtil.switchToThisWindow(wnd);
        return wnd;
    }

    protected static Wnd findDialogWnd(String title, String childClassName, String childText) throws Exception {
        Wnd wnd = Wnd.findWindow((String)DIALOG_CLASSNAME, (String)title);
        IEUtil.debugWnd(wnd, "findByTitleAndChild");
        if (wnd.isWindow()) {
            IEUtil.debugWndChildren(wnd, "findByTitleAndChild");
            Wnd childWnd = Wnd.findWindowEx((Wnd)wnd, (String)childClassName, (String)childText);
            IEUtil.debugWnd(childWnd, "aChildWnd");
            if (childWnd.isWindow()) {
                return wnd;
            }
        }
        return null;
    }

    protected static void clickWindow(Wnd wnd) {
        wnd.sendMessageEx(245, 0L, 0L);
    }

    protected static void clickWindowUntilGone(final Wnd wnd, final Wnd windowToWaitOn) throws Exception {
        new WaiterImpl(10000L, 200L).waitUntil(new Ready(){

            public boolean isReady() throws Exception {
                IEUtil.clickWindow(wnd);
                Debug.getInstance().println("windowToWaitOn.isWindow()=" + windowToWaitOn.isWindow());
                Debug.getInstance().println("windowToWaitOn.isVisible()=" + windowToWaitOn.isVisible());
                return !windowToWaitOn.isWindow();
            }

            public String getNotReadyReason() {
                return "Dialog never went away";
            }
        });
    }

    protected static String getStaticText(Wnd wnd) {
        List children = wnd.getChildWindows();
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < children.size(); ++i) {
            Wnd childWnd = (Wnd)children.get(i);
            if (!"Static".equals(childWnd.getWindowClassName())) continue;
            text.append(childWnd.getWindowText());
        }
        return text.toString();
    }

    public static void closeAllDialogs() {
        List windows = Wnd.getAllWindows();
        for (int i = 0; i < windows.size(); ++i) {
            Wnd wnd = (Wnd)windows.get(i);
            if (!DIALOG_CLASSNAME.equals(wnd.getWindowClassName()) || !wnd.getParent().isWindow() || !"IEFrame".equals(wnd.getParent().getWindowClassName())) continue;
            int wm_quit = 18;
            wnd.postMessage(wm_quit, 0L, 0L);
        }
    }

    protected static void waitUntilDocumentComplete(final IHTMLDocument2 ihtmlDocument2) throws Exception {
        Debug.getInstance().println("Begin IEUtil.waitUntilDocumentComplete(final IHTMLDocument2 ihtmlDocument2)");
        new WaiterImpl(180000L, 200L).waitUntil(new Ready(){
            String readyState;

            public boolean isReady() throws Exception {
                this.readyState = ihtmlDocument2.getReadyState().getValue();
                IEUtil.debug("Document is " + this.readyState);
                IEUtil.debug("Document complete? " + ("complete".equalsIgnoreCase(this.readyState) || "uninitialized".equalsIgnoreCase(this.readyState)));
                return "complete".equalsIgnoreCase(this.readyState) || "uninitialized".equalsIgnoreCase(this.readyState);
            }

            public String getNotReadyReason() {
                return "Document is not 'complete'...its last known state was '" + this.readyState + "'";
            }
        });
        Debug.getInstance().println("End IEUtil.waitUntilDocumentComplete(final IHTMLDocument2 ihtmlDocument2)");
    }

    static interface BrowserAction {
        public boolean perform(IWebBrowser2 var1, OleMessageLoop var2) throws Exception;
    }
}

