/*
 * Decompiled with CFR 0.152.
 */
package watij.elements;

import watij.WatijTestCase;
import watij.finders.SymbolFactory;

public class FormsXPathTest
extends WatijTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "forms2.html");
    }

    public void testFormExists() throws Exception {
        FormsXPathTest.assertTrue((boolean)ie.form(SymbolFactory.xpath, "//FORM[@name='test2']").exists());
        FormsXPathTest.assertFalse((boolean)ie.form(SymbolFactory.xpath, "//FORM[@name='missing']").exists());
        FormsXPathTest.assertTrue((boolean)ie.form(SymbolFactory.xpath, "//FORM[@method='get']").exists());
        FormsXPathTest.assertFalse((boolean)ie.form(SymbolFactory.xpath, "//FORM[@method='missing']").exists());
        FormsXPathTest.assertTrue((boolean)ie.form(SymbolFactory.xpath, "//FORM[@action='pass.html']").exists());
        FormsXPathTest.assertFalse((boolean)ie.form(SymbolFactory.xpath, "//FORM[@action='missing']").exists());
    }

    public void testButtonInForm() throws Exception {
        FormsXPathTest.assertTrue((boolean)ie.form(SymbolFactory.xpath, "//FORM[@name='test2']").button(SymbolFactory.caption, "Submit").exists());
    }

    public void testForm3Exists() throws Exception {
        ie.goTo(HTML_ROOT + "forms3.html");
        FormsXPathTest.assertTrue((boolean)ie.form(SymbolFactory.xpath, "//FORM[@name='test2']").exists());
        FormsXPathTest.assertFalse((boolean)ie.form(SymbolFactory.xpath, "//FORM[@name='missing']").exists());
        FormsXPathTest.assertTrue((boolean)ie.form(SymbolFactory.xpath, "//FORM[@method='get']").exists());
        FormsXPathTest.assertFalse((boolean)ie.form(SymbolFactory.xpath, "//FORM[@method='missing']").exists());
        FormsXPathTest.assertTrue((boolean)ie.form(SymbolFactory.xpath, "//FORM[@action='pass.html']").exists());
        FormsXPathTest.assertFalse((boolean)ie.form(SymbolFactory.xpath, "//FORM[@action='missing']").exists());
    }

    public void testflash1() throws Exception {
        ie.goTo(HTML_ROOT + "forms3.html");
        ie.form(SymbolFactory.xpath, "//FORM[@name='test2']").button(SymbolFactory.caption, "Submit").flash();
    }

    public void testcorrectformfieldisfoundusingformname() throws Exception {
        ie.goTo(HTML_ROOT + "forms4.html");
        FormsXPathTest.assertEquals((String)ie.form(SymbolFactory.xpath, "//FORM[@name='apple_form']").textField(SymbolFactory.name, "name").value(), (String)"apple");
        FormsXPathTest.assertEquals((String)ie.form(SymbolFactory.xpath, "//FORM[@name='banana_form']").textField(SymbolFactory.name, "name").value(), (String)"banana");
    }

    public void testusingtextonform() throws Exception {
        ie.goTo(HTML_ROOT + "forms4.html");
        ie.form(SymbolFactory.xpath, "//FORM[@name='apple_form']").textField(SymbolFactory.name, "name").set("strudel");
        FormsXPathTest.assertEquals((String)ie.form(0).textField(SymbolFactory.name, "name").value(), (String)"strudel");
    }

    public void testsubmit() throws Exception {
        ie.goTo(HTML_ROOT + "forms4.html");
        ie.form(SymbolFactory.xpath, "//FORM[@name='apple_form']").submit();
        FormsXPathTest.assertTrue((boolean)ie.containsText("PASS"));
    }

    public void testhidden() throws Exception {
        ie.goTo(HTML_ROOT + "forms3.html");
        FormsXPathTest.assertTrue((boolean)ie.form(SymbolFactory.xpath, "//FORM[@name='has_a_hidden']").hidden(SymbolFactory.name, "hid1").exists());
        FormsXPathTest.assertTrue((boolean)ie.form(SymbolFactory.xpath, "//FORM[@name='has_a_hidden']").hidden(SymbolFactory.id, "hidden_1").exists());
        FormsXPathTest.assertFalse((boolean)ie.form(SymbolFactory.xpath, "//FORM[@name='has_a_hidden']").hidden(SymbolFactory.name, "hidden_44").exists());
        FormsXPathTest.assertFalse((boolean)ie.form(SymbolFactory.xpath, "//FORM[@name='has_a_hidden']").hidden(SymbolFactory.id, "hidden_55").exists());
        ie.form(SymbolFactory.xpath, "//FORM[@name='has_a_hidden']").hidden(SymbolFactory.name, "hid1").set("222");
        ie.form(SymbolFactory.xpath, "//FORM[@name='has_a_hidden']").hidden(SymbolFactory.id, "hidden_1").set("333");
        ie.button(SymbolFactory.value, "Show Hidden").click();
        FormsXPathTest.assertEquals((String)"222", (String)ie.textField(SymbolFactory.name, "vis1").value());
        FormsXPathTest.assertEquals((String)"333", (String)ie.textField(SymbolFactory.name, "vis2").value());
    }
}

