/*
 * Decompiled with CFR 0.152.
 */
package watij.elements;

import watij.WatijTestCase;
import watij.elements.Link;
import watij.finders.SymbolFactory;
import watij.utilities.StringUtils;
import watij.utilities.Utils;

public class LinksTest
extends WatijTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "links1.html");
    }

    public void testNewLinkExists() throws Exception {
        LinksTest.assertTrue((boolean)ie.link(SymbolFactory.text, "test1").exists());
        LinksTest.assertTrue((boolean)ie.link(SymbolFactory.text, "/(?i:TEST)/").exists());
    }

    public void testMissingLinksDontExist() throws Exception {
        LinksTest.assertFalse((boolean)ie.link(SymbolFactory.text, "missing").exists());
        LinksTest.assertFalse((boolean)ie.link(SymbolFactory.text, "/miss/").exists());
    }

    public void testLinkExists() throws Exception {
        LinksTest.assertTrue((boolean)ie.link(SymbolFactory.text, "test1").exists());
        LinksTest.assertTrue((boolean)ie.link(SymbolFactory.text, "/(?i:TEST)/").exists());
        LinksTest.assertFalse((boolean)ie.link(SymbolFactory.text, "missing").exists());
        LinksTest.assertFalse((boolean)ie.link(SymbolFactory.text, "/miss/").exists());
        LinksTest.assertTrue((boolean)ie.link(SymbolFactory.url, "/link_pass.html/").exists());
        LinksTest.assertFalse((boolean)ie.link(SymbolFactory.url, "alsomissing.html").exists());
        LinksTest.assertTrue((boolean)ie.link(SymbolFactory.id, "link_id").exists());
        LinksTest.assertFalse((boolean)ie.link(SymbolFactory.id, "alsomissing").exists());
        LinksTest.assertTrue((boolean)ie.link(SymbolFactory.id, "/_id/").exists());
        LinksTest.assertFalse((boolean)ie.link(SymbolFactory.id, "/ alsomissing /").exists());
        LinksTest.assertTrue((boolean)ie.link(SymbolFactory.name, "link_name").exists());
        LinksTest.assertFalse((boolean)ie.link(SymbolFactory.name, "alsomissing").exists());
        LinksTest.assertTrue((boolean)ie.link(SymbolFactory.name, "/_n/").exists());
        LinksTest.assertFalse((boolean)ie.link(SymbolFactory.name, "/missing/").exists());
        LinksTest.assertTrue((boolean)ie.link(SymbolFactory.title, "/ti/").exists());
        LinksTest.assertTrue((boolean)ie.link(SymbolFactory.title, "link_title").exists());
        LinksTest.assertFalse((boolean)ie.link(SymbolFactory.title, "/missing/").exists());
        LinksTest.assertTrue((boolean)ie.link(SymbolFactory.url, "/_pass/").exists());
        LinksTest.assertFalse((boolean)ie.link(SymbolFactory.url, "/dont_exist/").exists());
    }

    public void testLinkClick() throws Exception {
        ie.link(SymbolFactory.text, "test1").click();
        LinksTest.assertTrue((boolean)ie.text().contains("Links2-Pass"));
    }

    public void testLink2Click() throws Exception {
        ie.link(SymbolFactory.url, "/link_pass.html/").click();
        LinksTest.assertTrue((boolean)ie.text().contains("Links3-Pass"));
    }

    public void testLink3Click() throws Exception {
        ie.link(0).click();
        LinksTest.assertTrue((boolean)ie.text().contains("Links2-Pass"));
    }

    public void testLink4Click() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodClick(ie.link(199));
    }

    public void test_link_properties() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodValue(ie.link(199));
        this.assertRaisesUnknownObjectExceptionForMethodInnerText(ie.link(199));
        this.assertRaisesUnknownObjectExceptionForMethodName(ie.link(199));
        this.assertRaisesUnknownObjectExceptionForMethodId(ie.link(199));
        this.assertRaisesUnknownObjectExceptionForMethodDisabled(ie.link(199));
        this.assertRaisesUnknownObjectExceptionForMethodType(ie.link(199));
        LinksTest.assertTrue((boolean)StringUtils.matchesOrEquals("/links2/", ie.link(0).href()));
        LinksTest.assertTrue((boolean)Utils.isEmpty(ie.link(0).value()));
        LinksTest.assertEquals((String)"test1", (String)ie.link(0).innerText());
        LinksTest.assertEquals((String)"", (String)ie.link(0).name());
        LinksTest.assertEquals((String)"", (String)ie.link(0).id());
        LinksTest.assertEquals((boolean)false, (boolean)ie.link(0).disabled());
        LinksTest.assertEquals((String)"", (String)ie.link(0).className());
        LinksTest.assertEquals((String)"link_class_1", (String)ie.link(1).className());
        LinksTest.assertEquals((String)"link_id", (String)ie.link(5).id());
        LinksTest.assertEquals((String)"link_name", (String)ie.link(6).name());
        LinksTest.assertEquals((String)"", (String)ie.link(6).title());
        LinksTest.assertEquals((String)"link_title", (String)ie.link(7).title());
    }

    public void test_link_iterator() throws Exception {
        LinksTest.assertEquals((int)9, (int)ie.links().length());
        LinksTest.assertEquals((String)"Link Using a name", (String)((Link)ie.links().get(6)).innerText());
        int i = 0;
        for (Link link : ie.links()) {
            LinksTest.assertEquals((String)ie.link(i).href(), (String)link.href());
            LinksTest.assertEquals((String)ie.link(i).id(), (String)link.id());
            LinksTest.assertEquals((String)ie.link(i).name(), (String)link.name());
            LinksTest.assertEquals((String)ie.link(i).innerText(), (String)link.innerText());
            ++i;
        }
    }
}

