/*
 * Decompiled with CFR 0.152.
 */
package watij.elements;

import watij.WatijTestCase;
import watij.finders.SymbolFactory;

public class ButtonsXpathTest
extends WatijTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "buttons1.html");
    }

    public void testProperties() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodId(ie.button(SymbolFactory.xpath, "//INPUT[@name='noName']"));
        this.assertRaisesUnknownObjectExceptionForMethodName(ie.button(SymbolFactory.xpath, "//INPUT[@name='noName']"));
        this.assertRaisesUnknownObjectExceptionForMethodDisabled(ie.button(SymbolFactory.xpath, "//INPUT[@name='noName']"));
        this.assertRaisesUnknownObjectExceptionForMethodType(ie.button(SymbolFactory.xpath, "//INPUT[@name='noName']"));
        this.assertRaisesUnknownObjectExceptionForMethodValue(ie.button(SymbolFactory.xpath, "//INPUT[@name='noName']"));
        ButtonsXpathTest.assertEquals((String)"b1", (String)ie.button(SymbolFactory.xpath, "//INPUT[@id='b2']").name());
        ButtonsXpathTest.assertEquals((String)"b2", (String)ie.button(SymbolFactory.xpath, "//INPUT[@id='b2']").id());
        ButtonsXpathTest.assertEquals((String)"button", (String)ie.button(SymbolFactory.xpath, "//INPUT[@id='b2']").type());
    }

    public void testButtonUsingDefault() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodClick(ie.button(SymbolFactory.xpath, "//INPUT[@value='Missing Caption']"));
        ie.button(SymbolFactory.xpath, "//INPUT[@value='Click Me']").click();
        assert (ie.text().contains("PASS"));
    }

    public void testButtonClickOnly() throws Exception {
        ie.button(SymbolFactory.xpath, "//INPUT[@value='Click Me']").click();
        ButtonsXpathTest.assertTrue((boolean)ie.text().contains("PASS"));
    }

    public void testButtonClick() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodClick(ie.button(SymbolFactory.xpath, "//INPUT[@value='Missing Caption']"));
        this.assertRaisesUnknownObjectExceptionForMethodClick(ie.button(SymbolFactory.xpath, "//INPUT[@id='MissingId']"));
        this.assertRaisesObjectDisabledExceptionForMethodClick(ie.button(SymbolFactory.xpath, "//INPUT[@value='Disabled Button']"));
        ie.button(SymbolFactory.xpath, "//INPUT[@value='Click Me']").click();
        ButtonsXpathTest.assertTrue((boolean)ie.text().contains("PASS"));
    }

    public void testButtonExists() throws Exception {
        ButtonsXpathTest.assertTrue((boolean)ie.button(SymbolFactory.xpath, "//INPUT[@value='Click Me']").exists());
        ButtonsXpathTest.assertTrue((boolean)ie.button(SymbolFactory.xpath, "//INPUT[@value='Submit']").exists());
        ButtonsXpathTest.assertTrue((boolean)ie.button(SymbolFactory.xpath, "//INPUT[@name='b1']").exists());
        ButtonsXpathTest.assertTrue((boolean)ie.button(SymbolFactory.xpath, "//INPUT[@id='b2']").exists());
        ButtonsXpathTest.assertFalse((boolean)ie.button(SymbolFactory.xpath, "//INPUT[@value='Missing Caption']").exists());
        ButtonsXpathTest.assertFalse((boolean)ie.button(SymbolFactory.xpath, "//INPUT[@name='missingname']").exists());
        ButtonsXpathTest.assertFalse((boolean)ie.button(SymbolFactory.xpath, "//INPUT[@id='missingid']").exists());
    }

    public void testButtonEnabled() throws Exception {
        ButtonsXpathTest.assertTrue((boolean)ie.button(SymbolFactory.xpath, "//INPUT[@value='Click Me']").enabled());
        ButtonsXpathTest.assertFalse((boolean)ie.button(SymbolFactory.xpath, "//INPUT[@value='Disabled Button']").enabled());
        ButtonsXpathTest.assertFalse((boolean)ie.button(SymbolFactory.xpath, "//INPUT[@name='b4']").enabled());
        ButtonsXpathTest.assertFalse((boolean)ie.button(SymbolFactory.xpath, "//INPUT[@id='b5']").enabled());
    }
}

