/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.automation;

import com.jniwrapper.win32.Size;
import com.jniwrapper.win32.gdi.WindowDC;
import com.jniwrapper.win32.system.Kernel32;
import com.jniwrapper.win32.ui.Wnd;
import java.awt.Point;

public class GraphicsUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Point getPixelsPerInch() {
        Point point = new Point(96, 96);
        WindowDC windowDC = new WindowDC(new Wnd());
        try {
            point.x = windowDC.getDeviceCaps(88);
            point.y = windowDC.getDeviceCaps(90);
        }
        finally {
            windowDC.release();
        }
        return point;
    }

    public static Size pixelsToHimetric(Size size) {
        if (size == null) {
            throw new IllegalArgumentException();
        }
        Point point = GraphicsUtils.getPixelsPerInch();
        Size size2 = new Size(Kernel32.mulDiv((int)size.getCx(), (int)2540, (int)point.x), Kernel32.mulDiv((int)size.getCy(), (int)2540, (int)point.y));
        return size2;
    }

    public static Size himetricToPixels(Size size) {
        if (size == null) {
            throw new IllegalArgumentException();
        }
        Point point = GraphicsUtils.getPixelsPerInch();
        Size size2 = new Size(Kernel32.mulDiv((int)size.getCx(), (int)point.x, (int)2540), Kernel32.mulDiv((int)size.getCy(), (int)point.y, (int)2540));
        return size2;
    }
}

