/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Library;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Str;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.LastErrorException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileInformation {
    private static final FunctionName GetFileVersionInfo = new FunctionName("GetFileVersionInfo");
    private static final FunctionName GetFileVersionInfoSize = new FunctionName("GetFileVersionInfoSize");
    private static final FunctionName VerQueryValue = new FunctionName("VerQueryValue");
    private Pointer dataBufferPtr = new Pointer(null, true);
    private VS_FIXEDFILEINFO fixedfileinfo = new VS_FIXEDFILEINFO();
    private Library version;
    static /* synthetic */ Class class$com$jniwrapper$UInt8;

    public FileInformation(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file);
        }
        String fileName = file.getAbsolutePath();
        this.version = new Library("version");
        Function getFileVersionInfoSize = this.version.getFunction(GetFileVersionInfoSize.toString());
        UInt32 fileInfoSize = new UInt32();
        getFileVersionInfoSize.invoke((Parameter)fileInfoSize, (Parameter)new Str(fileName), (Parameter)new Pointer.Void());
        Function getFileVersionInfo = this.version.getFunction(GetFileVersionInfo.toString());
        Bool result = new Bool();
        PrimitiveArray dataBuffer = new PrimitiveArray(class$com$jniwrapper$UInt8 == null ? (class$com$jniwrapper$UInt8 = FileInformation.class$("com.jniwrapper.UInt8")) : class$com$jniwrapper$UInt8, (int)fileInfoSize.getValue());
        this.dataBufferPtr = new Pointer((Parameter)dataBuffer);
        long lastErrorCode = getFileVersionInfo.invoke((Parameter)result, (Parameter)new Str(fileName), (Parameter)new UInt32(), (Parameter)fileInfoSize, (Parameter)this.dataBufferPtr);
        if (!result.getValue()) {
            throw new LastErrorException(lastErrorCode);
        }
        Function verQueryValue = this.version.getFunction(VerQueryValue.toString());
        this.fixedfileinfo = new VS_FIXEDFILEINFO();
        UInt bufferSize = new UInt();
        lastErrorCode = verQueryValue.invoke((Parameter)result, (Parameter)this.dataBufferPtr, (Parameter)new Str("\\"), (Parameter)new Pointer((Parameter)new Pointer((Parameter)this.fixedfileinfo)), (Parameter)new Pointer((Parameter)bufferSize));
        if (!result.getValue()) {
            throw new LastErrorException(lastErrorCode);
        }
    }

    public int getMajorVersion() {
        return (int)FileInformation.getHighWord(this.fixedfileinfo.FileVersionMS.getValue());
    }

    public int getMinorVersion() {
        return (int)FileInformation.getLoWord(this.fixedfileinfo.FileVersionMS.getValue());
    }

    private static long getHighWord(long value) {
        return (value & 0xFFFFFFFFFFFF0000L) >> 16;
    }

    private static long getLoWord(long value) {
        return value & 0xFFFFL;
    }

    public String getCompanyName() {
        Function verQueryValue = this.version.getFunction(VerQueryValue.toString());
        Bool result = new Bool();
        UInt32 langInfo = new UInt32();
        long lastErrorCode = verQueryValue.invoke((Parameter)result, (Parameter)this.dataBufferPtr, (Parameter)new Str("\\VarFileInfo\\Translation"), (Parameter)new Pointer((Parameter)new Pointer((Parameter)langInfo)), (Parameter)new Pointer((Parameter)new UInt()));
        if (!result.getValue()) {
            throw new LastErrorException(lastErrorCode);
        }
        StringBuffer verStrName = new StringBuffer("\\StringFileInfo\\");
        long language = FileInformation.getLoWord(langInfo.getValue());
        String langStr = Long.toHexString(language);
        verStrName.append("0").append(langStr.toUpperCase());
        long codePage = FileInformation.getHighWord(langInfo.getValue());
        String codePageStr = Long.toHexString(codePage);
        verStrName.append("0").append(codePageStr.toUpperCase());
        verStrName.append("\\CompanyName");
        Str companyName = new Str();
        lastErrorCode = verQueryValue.invoke((Parameter)result, (Parameter)this.dataBufferPtr, (Parameter)new Str(verStrName.toString()), (Parameter)new Pointer((Parameter)new Pointer((Parameter)companyName)), (Parameter)new UInt());
        if (!result.getValue()) {
            throw new LastErrorException(lastErrorCode);
        }
        return companyName.getValue();
    }

    public static void main(String[] args) throws Exception {
        File file = new File("c:\\Program Files\\Internet Explorer\\iexplore.exe");
        FileInformation fileInformation = new FileInformation(file);
        System.out.println("fileInformation.getMajorVersion() = " + fileInformation.getMajorVersion());
        System.out.println("fileInformation.getMinorVersion() = " + fileInformation.getMinorVersion());
        System.out.println("fileInformation.getCompanyName() = " + fileInformation.getCompanyName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class VS_FIXEDFILEINFO
    extends Structure {
        UInt32 Signature = new UInt32();
        UInt32 StrucVersion = new UInt32();
        UInt32 FileVersionMS = new UInt32();
        UInt32 FileVersionLS = new UInt32();
        UInt32 ProductVersionMS = new UInt32();
        UInt32 ProductVersionLS = new UInt32();
        UInt32 FileFlagsMask = new UInt32();
        UInt32 FileFlags = new UInt32();
        UInt32 FileOS = new UInt32();
        UInt32 FileType = new UInt32();
        UInt32 FileSubtype = new UInt32();
        UInt32 FileDateMS = new UInt32();
        UInt32 FileDateLS = new UInt32();

        public VS_FIXEDFILEINFO() {
            this.init(new Parameter[]{this.Signature, this.StrucVersion, this.FileVersionMS, this.FileVersionLS, this.ProductVersionMS, this.ProductVersionLS, this.FileFlagsMask, this.FileFlags, this.FileOS, this.FileType, this.FileSubtype, this.FileDateMS, this.FileDateLS}, (short)4);
        }

        public Object clone() {
            VS_FIXEDFILEINFO clone = new VS_FIXEDFILEINFO();
            clone.initFrom(this);
            return clone;
        }
    }
}

