#ifndef INCLUDED_SCHED_TASK_BASE
#define INCLUDED_SCHED_TASK_BASE

#include "base.h"
#include <stdio.h>
#include <stdlib.h>

class TaskManagerImpl;
class Scheduler;
class MemorySegment;
class MemList;
class HTask;

class SchedTaskBase {
public:
    /* constructor */
    // void *called ;  // for debug
    SchedTaskBase() {
	// called = __builtin_return_address(1);
    }
    virtual ~SchedTaskBase() {}

    BASE_NEW_DELETE(SchedTaskBase);

    // noaction in default
    // virtual void load()  {}
    virtual void read()  {}
    virtual void exec()  {}
    virtual void write() {}
    virtual SchedTaskBase* next(Scheduler *, SchedTaskBase*) {return 0;}

    /* functions */
    virtual void* get_output(void *buff, int index) { return 0; }
    virtual void* get_input(void *buff, int index) { return 0;}
    virtual memaddr get_param(int index) { return 0;}
    virtual int read_size() { return 0;}
    virtual int printf(const char * format, ...) {return 0;};

    virtual memaddr get_inputAddr(int index) {return 0;}
    virtual memaddr get_outputAddr(int index) {return 0;}
    virtual int get_inputSize(int index) {return 0;}
    virtual int get_outputSize(int index) {return 0;}

    virtual int get_cpuid() {return 0;}

    virtual void* global_alloc(int id, int size) {return 0;}
    virtual void* global_get(int id) {return 0;}
    virtual void global_set(int id, void *addr) {}
    virtual void global_free(int id) {}
    virtual MemList* createMemList(int size, int count) {return 0;}

    virtual void mainMem_alloc(int id, int size) {}
    virtual void mainMem_wait() {}
    virtual memaddr mainMem_get(int id) {return 0; }

    virtual MemorySegment * get_segment(memaddr addr, MemList *m) {return 0; }
    virtual uint32 get_tag() {return 0; }
    virtual void put_segment(MemorySegment *s) {}
    virtual void wait_segment(MemorySegment *s) {}

    virtual void *allocate(int size) {return 0; }
    virtual void free_(void *p)  {}
    // virtual void polling();

    /* これは禁止するべき */
    virtual void dma_load(void *buf, memaddr addr, uint32 size, uint32 mask) {}
    virtual void dma_store(void *buf,memaddr addr, uint32 size, uint32 mask) {}
    virtual void dma_wait(uint32 mask) {}

    virtual void show_dma_wait() {}
    virtual void start_profile() {}
    virtual void* allocate(int size,int align) {return 0;}
    virtual Scheduler* get_scheduler() {return 0;}
    virtual long get_random() {return 0;}
    virtual void free_htask(HTask *h) {}

    /* variables */

    // SchedTask は、すべて同じ大きさであるべきなので、継承するクラスには、
    // 変数を置かない。ここに、すべて置く。virtual も含めて。

    // Task を実行するスケジューラ自身
    Scheduler *scheduler;
    // Task を作成管理するマネージャー
    TaskManagerImpl *manager;

    SimpleTaskPtr task;
    TaskPtr atask;
    SchedTaskBase *savedTask;

    // 現在スケジューラが実行している TaskList と、このタスクに対応する Task
    TaskListPtr list;
    // Task の、Tasklist での位置。(task = &list[cur_index-1])
    int cur_index;

    int tag;

    memaddr params_addr;
    memaddr waiter;
    Task *array;

    /**
     * read データ、write 用のバッファ
     * readbuf には タスク登録時に設定した入力データが入っている。
     * writebuf にデータを描き込んでおくと、
     * タスク登録時に設定した出力先に書き込む
     */
    void *readbuf;
    void *writebuf;

    /* system call */

    FILE *stdout_;
    FILE *stderr_;
    FILE *stdin_;

    // Task Array しか使わないが、たいした大きさではないのでいいか...
    ListData inListData;
    ListData outListData;

}  ;

#endif
