#ifndef INCLUDED_SCHED_TASK
#define INCLUDED_SCHED_TASK

#include "base.h"
#include "Scheduler.h"
#include "SchedTaskBase.h"
#include "ListData.h"
#include "HTask.h"
#include "MemList.h"


class SchedTask : public SchedTaskBase {
public:
    /* constructor */
    SchedTask();
    virtual ~SchedTask();

    BASE_NEW_DELETE(SchedTask);

    /* variables */

    /* functions */

    // override
    void read();
    void exec();
    void write();
    SchedTaskBase* next(Scheduler *, SchedTaskBase *);

    // タスクの処理は、task_list に登録された C の関数によっておこなう

public:
    /* functions */

    void init(TaskListPtr _list, SimpleTaskPtr _task, int index,
	      Scheduler* sc, int tag);

    //---  User API ---
    int read_size() { return task->r_size; }
    int write_size() { return task->w_size; }
    void set_write_size(int w) { task->w_size = w; }

    void* get_input(void *buff, int index);
    void* get_output(void *buff, int index);
    memaddr get_param(int index);
    memaddr get_inputAddr(int index);
    memaddr get_outputAddr(int index);
    // 書き出しを追加する API がない... 
    int get_inputSize(int index);
    int get_outputSize(int index);

    int get_cpuid();

    void* global_alloc(int id, int size);
    void* global_get(int id);
    void global_set(int id, void *addr);
    void global_free(int id);
    MemList* createMemList(int size, int count);

    void mainMem_alloc(int id, int size);
    void mainMem_wait();
    memaddr mainMem_get(int id);

    MemorySegment * get_segment(memaddr addr, MemList *m);
    uint32 get_tag();
    void put_segment(MemorySegment *s);
    void wait_segment(MemorySegment *s);



    void *allocate(int size);
    void free_(void *p) ;
    void free_htask(HTask *p) ;

    void polling();

    /* これは禁止するべき */
    void dma_load(void *buf, memaddr addr, uint32 size, uint32 mask);
    void dma_store(void *buf,memaddr addr, uint32 size, uint32 mask);
    void dma_wait(uint32 mask);

    void show_dma_wait();
    void start_profile();


    /*!
      SPU用の get_input, get_output
     */
    void* get_input(int index) {
      return get_input(readbuf, index);
    }

    void* get_output(int index) {
      return get_output(writebuf, index);
    }

    /**
     * swap read / write buffer
     * output が read buffer の書き換えならば、memcpy せずに
     * swap するだけで良い。size は同じである必要がある。
     */
    void swap() {
	void * tmp = readbuf;
	readbuf = writebuf;
	writebuf = tmp;
    }


    // user
    HTaskPtr create_task(int cmd);
    HTaskPtr create_task(int cmd, memaddr r, long rs, memaddr w, long ws);
    HTaskPtr create_task_array(int id, int num_task, int num_param, int num_inData, int num_outData);

    void set_task_depend(HTaskPtr master, HTaskPtr slave);
    void spawn_task(HTaskPtr);
    void set_task_cpu(HTaskPtr, CPU_TYPE);
    void* allocate(int size,int align);
    Scheduler* get_scheduler();
    long get_random();

    int printf(const char * format, ...);

} ;


extern void loadSchedTask(Scheduler *scheduler,TaskPtr task);

#endif

