#ifndef INCLUDED_TEXTURE
#define INCLUDED_TEXTURE

#if !defined(__SPU__)

#include <SDL.h>
#include <SDL_opengl.h>

extern int power_of_two(int input);
extern GLuint SDL_GL_LoadTexture(SDL_Surface *surface);

typedef struct texture_list {
    int t_w;
    int t_h;
    uint32 *pixels_orig;
    uint32 *pixels;
    int scale_max;
    SDL_Surface *texture_image;
    GLuint gl_tex;
    int pad[1]; // 12

} texture_list, *texture_list_ptr ; // 20 + pad(12) = 32

#else

typedef struct texture_list {
    int t_w;
    int t_h;
    uint32 *pixels_orig;
    uint32 *pixels;
    int scale_max;
    void *texture_image;
    void *gl_tex;
    int pad[1]; // 12

} texture_list, *texture_list_ptr ; // 20 + pad(12) = 32

#endif

#endif
