#ifndef INCLUDED_POLYGON_PACK
#define INCLUDED_POLYGON_PACK

#include "types.h"

#define MAX_SIZE_TRIANGLE 128

typedef struct VertexPack {
    float x;
    float y;
    float z;
    float tex_x;
    float tex_y;
} VertexPack, *VertexPackPtr; // 20

typedef struct NormalPack {
  float x;
  float y;
  float z;
} NormalPack, *NormalPackPtr; // 12  

typedef struct TriTexInfo {
    uint32 *addr;
    int width;
    int height;
    int scale_max;
} TriangleTexInfo, *TriangleTexInfoPtr; // 16

typedef struct TrianglePack {
    TriTexInfo tex_info; // 16
    VertexPack ver1;     // 20
    VertexPack ver2;     // 20
    VertexPack ver3;     // 20
    NormalPack normal1;  // 12
    NormalPack normal2;  // 12
    NormalPack normal3;  // 12
} TrianglePack, *TrianglePackPtr; // 112 (16 * 7)


typedef struct PolygonPack {

    TrianglePack tri[MAX_SIZE_TRIANGLE];

    struct POLYGON_info {
	int size;
	int light_pos[3];
	int light_rgb[3];
    }info;

    PolygonPack* next;

    void init(void) {
	info.size = 0;
	next = 0;
    }

    void clear(void) {
	PolygonPack *q = 0;
	PolygonPack *q1 = 0;
	
	q = this->next;
	while (q) {
	    q1 = q->next;
	    delete(q);
	    q = q1;
	}
	this->init();
    }
} PolygonPack, *PolygonPackPtr; // 4*7 + 76*128 + 4 = 9760 なんやかんやで 14368 みたい。

typedef struct PolygonPackList {
    int size;
    PolygonPack *list;
} PolygonPackList;

#endif
