#ifndef INCLUDED_POLYGON
#define INCLUDED_POLYGON

#include <SDL.h>
#include <libxml/parser.h>
#include "polygon_pack.h"
#include "SpanPack.h"
#include "texture.h"

class Polygon {
public:
    long long size;
    const char *name;
    const char *parent_name;

    //float *data;    //"vertex" and "normal" and "texture"
    int coord_pack_size;

    float *coord_pack; //coord_xyz(4*3*size), coord_tex(4*3*size), normal(4*3*size), 
    float *coord_xyz; // vertex coordinate array
    float *coord_tex; // texture coordinate array
    float *normal;    // normal vector array
    float matrix[16];
    float real_matrix[16];
    texture_list texture_info;

    float xyz[4];     // position
    float angle[4];   // angle
    float c_xyz[4];   // center of rotation
    float *anim;
    int texture_id; //texture id number

    SDL_Surface* texture_image;

    Polygon(void);

    void parameter_change(char *name, float x, float y, float z, float ax, float ay, float az);
    //void load_texture(char *image_name);
    //void draw(float *stack);
    //void draw(SceneGraphPack *sgp);
    //void draw(PolygonPack *pp);
    //void draw(SpanPack *sp);
    Uint32 get_rgb(int tx, int ty);

public:
    void position_init(void);

    void tree_draw();
    void pickup_coordinate(char *cont);
    void pickup_normal(char *cont);
    void pickup_model(char *cont);
    void pickup_texture(char *cont);
};

#endif
