#include <stdio.h>
#include <string.h>
#include "Print.h"
#include "Func.h"
#include "WordCount.h"

/* これは必須 */
SchedDefineTask1(Print,run_print);

static int
run_print(SchedTask *s, void *rbuf, void *wbuf)
{
    WordCount *w = *(WordCount**)rbuf;
    unsigned long long *idata = w->o_data;
    // long task_num = w->task_num;
    long status_num = w->status_num;
    int out_task_num = w->out_task_num;

    /*
     *  head_flag
     *  o_data[0]
     *  o_data[1]
     *
     */
    unsigned long long word_data[2];

    int flag_cal_sum = 0;
    //printf("pad %d\n",pad);


    /* head_tail_flag : task = 2 : 1
     *
     *    head_tail_flag[2]
     *  ___________ __________
     * |           |          |
     * | head_flag | tail_fag | 
     * |___________|__________|
     *      [0]         [1] 
     * 
     * |----------------------|
     *    unsigned long long 
     *          16byte
     *
     * 配列先頭の head_flag はみない
     * 配列末尾の tail_flag はみない
     * 担当範囲前の末尾文字が「改行と、スペース以外」(tail_flag = 1)で、
     * 担当範囲の先頭文字が「改行とスペース」(head_flag = 0)の場合
     * 単語数を +1  することで、整合性がとれる。
     *
     * ex.
     *    task_num 4
     *    head_tail_flag[8]
     *
     *      0   1   2   3   4   5   6   7
     *     ___ ___ ___ ___ ___ ___ ___ ___ 
     *    | h | t | h | t | h | t | h | t |
     *    |___|___|___|___|___|___|___|___|
     *        |-------|-------|-------| 
     *           比較    比較    比較
     *
     */

    s->printf("start sum\n");

    for (int i = 0; i < status_num; i++) {
	word_data[i] = 0;
    }

    for (int i = 0; i < out_task_num ; i++) {
	word_data[0] += idata[i*w->out_size+0];
	word_data[1] += idata[i*w->out_size+1];
	unsigned long long *head_tail_flag = 
		       &idata[i*w->out_size+2];
        if((i!=out_task_num-1)&&
           (head_tail_flag[1] == 1) && (head_tail_flag[4] == 0)) {
	    flag_cal_sum++;
        }
    }

    word_data[0] += flag_cal_sum;

    for (int i = status_num-1; i >=0; i--) {
	s->printf("%llu ",word_data[i]);
    }

    //printf("j = %d\n",j);


    s->printf("\n");

    return 0;
}
