#include <stdio.h>
#include "Renew1.h"
#include "SpeProfile.h"
#include "Func.h"

/* これは必須 */
SchedDefineTask(Renew1);

static int
run(SchedTask *s, void *rbuf, void *wbuf)
{
    SpeProfile *profile = (SpeProfile*)s->global_get(0);
    profile->ProfStop();
    profile->ProfPrint();

    int *test_num = (int *)s->get_input(rbuf,0);
    int *local_num = (int *)s->get_param(0);

    s->printf("[SPE] Renew1 test_num = %d\n", *test_num);
    s->printf("[SPE] Renew1 local_num = %d\n", *local_num);

    s->printf("[SPE] ** running Renew1\n");
    
    s->printf("[SPE] Create Task : Renew2\n");
    HTaskPtr nextTask = s->create_task(RENEW2);
    nextTask->spawn();
    
    s->printf("[SPE] ** finish  Renew1\n\n");

    return 0;
}
