#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "TaskManager.h"
#include "Func.h"

extern void task_init(void);

static TaskManager *manager;

static int count = 1;

const char *usr_help_str = "Usage: ./post [-cpu spe_num] [-count N]\n\
  -count  Number of print \"Hello, World!!\"";

void
func1(SchedTask *m, void *p, void *q)
{
    long i = (long)p;

    printf("post function : %ld\n", i--);

    if (i > 0) {
	HTaskPtr next = manager->create_task(HELLO_TASK);
	next->set_param(0,(memaddr)i);
	next->set_post(func1, (void*)i, 0);
	next->set_cpu(SPE_ANY);
	next->spawn();    
    }
}


int
init(int argc, char **argv)
{
    for (int i = 1; argv[i]; ++i) {
	if (strcmp(argv[i], "-count") == 0) {
            count = atoi(argv[++i]);
        }
    }

    return 0;
}

void
run_init(TaskManager *manager)
{
    HTaskPtr task;

    task = manager->create_task(HELLO_TASK);
    task->set_param(0,(memaddr)count);
    task->set_post(func1, (void*)count, 0);
    task->set_cpu(SPE_ANY);
    task->spawn();
}

int
TMmain(TaskManager *manager_, int argc, char *argv[])
{
    manager = manager_;

    if (init(argc, argv) < 0) {
	return -1;
    }

    task_init();
    run_init(manager);

    return 0;
}

