#include <stdio.h>
#include "Hello.h"
#include "Func.h"

/* これは必須 */
SchedDefineDynamicTask(Hello,0);

static int
rel_offset()
{
    unsigned int pc;
    unsigned int label;
    __asm__ __volatile__(
"         brsl %0,____LLLL\n"
"____LLLL:"
"         ila  %1,____LLLL"
        : "=r" (pc), "=r" (label));
    return  pc-label;
}


static int
run(SchedTask *smanager, void *rbuf, void *wbuf)
{
    int task_id = (long)smanager->get_param(0);

    unsigned int pc;
    __asm__ __volatile__(
"         brsl %0,____LLLL1\n"
"____LLLL1:"
        : "=r" (pc));

    char *fmt = "char [%0x] offset [%0x]\n";
    int offset = rel_offset();

    //smanager->fprintf(smanager->stderr_,fmt+offset, fmt, offset);

    //smanager->fprintf(smanager->stderr_,"[%d] Hello, World!! Seg1 \n"+offset, task_id);
    //smanager->fprintf(smanager->stderr_,"pc=0x%0x 0x%0lx\n"+offset,pc, (unsigned long)&runTask_Hello);

    smanager->printf(fmt+offset, fmt, offset);

    smanager->printf("[%d] Hello, World!! Seg1\n"+offset, task_id);
    smanager->printf("pc=0x%0x 0x%0lx\n"+offset,pc, (unsigned long)&runTask_Hello);

    return 0;
}

