#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "TaskManager.h"
#include "Container.h"
#include "Func.h"

#define CONTAINER_DATA_SIZE 4096

extern void task_init(void);

static int count = 1;
static int spe_num = 1;
static int data_size = 10;
static int data_length = 1;

extern TaskManager *manager;

const char *usr_help_str = "Usage: ./resize [-cpu spe_num] [-count N]\n\
  -cpu    Number of SPE (default 1) \n\
  -count  Number of task is print \"Hello, World!!\"";

int
init(int argc, char **argv)
{
    for (int i = 1; argv[i]; ++i) {
	if (strcmp(argv[i], "-count") == 0) {
            count = atoi(argv[++i]);
        } else if (strcmp(argv[i], "-cpu") == 0) {
	    spe_num = atoi(argv[i+1]);
	} else if (strcmp(argv[i], "-length") == 0) {
	    data_length = atoi(argv[++i]);
	} 
    }

    return 0;
}


static void
checkData(SchedTask *s, void *data, void *arg1)
{
    ContainerPtr obj = (ContainerPtr)data;
    int data_length = obj->length;

    for(int i =0;i <data_length;i++) {
	int idata = obj->data[i];
	printf("data[%d] = %d\n", i, idata);
    }

    free(data);
}


static void
resize_init(TaskManager *manager)
{
    HTaskPtr resize_task = manager->create_task(RESIZE);
    ContainerPtr obj = (ContainerPtr)manager->allocate(CONTAINER_DATA_SIZE);
    obj->length = 0;

    resize_task->set_param(0, (memaddr)data_length);
    resize_task->set_outData(0, obj, 0);

    resize_task->set_post(checkData, (void*)obj, NULL);
    resize_task->set_cpu(SPE_ANY);
    resize_task->spawn();
}

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    if (init(argc, argv) < 0) {
	return -1;
    }

    // Task Register
    //   ppe/task_init.cc
    task_init();

    resize_init(manager);

    return 0;
}
