#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <strings.h>
#include "TaskManager.h"
#include "Func.h"
#include "MemList.h"
#include "MemorySegment.h"


const char *usr_help_str = "Usage: ./hello [-cpu spe_num] [-count N]\n\
  -cpu    Number of SPE (default 1) \n                                \
  -count  Number of task is print \"Hello, World!!\"";


void
test1(TaskManager *manager, MemList* active, MemList* freelist, uint32 size, uint32 count)
{
/*!
  active からランダムに要素を取り出してそこの size の領域を書き潰す
  そこを moveToFirst を繰り返すテスト
 */
    for (uint32 i = 0; i < count; i++) {
        int index = manager->get_random()%count;
        MemorySegment* e = active->get(index);
        active->moveToFirst(e);
        bzero(e->data, size);
    }
    printf("test1\n");
}


int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    uint32 size = 128;
    uint32 count = 64;

    MemList* active = manager->createMemList(size, 0);
    MemList* freelist = manager->createMemList(size, count);

    // 配列！
    uint32 i = 0;
    for (;; i++) {
        MemorySegment* m = freelist->poll();
        if (m == 0) {
            break;
        }
        active->addFirst(m);
    }

    assert(i==count);
    printf("count = %d\n", i);

    test1(manager, active, freelist, size, count);
    delete active;
    delete freelist;

    return 0;
}

/* end */
