#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "TaskManager.h"
#include "Task.h"
#include "ListData.h"
#include "Func.h"

extern void task_init(void);

static int length = DATA_NUM;
static int task = 3;
static int task_array_num = 3;
static int block_num = 3;

const char *usr_help_str = "Usage: ./twice [-length data_length] [-task_array_num task_num]\n\
  -task_array_num Number of data in a block (default 16)\n\
  -block_num      Number of block\n\
  -task           Number of task\n\
  -block_size     Size of a block\n";


static void
print_data(int *data, int size, const char *title)
{
    printf("%s ---\n", title);
    for (int i = 0; i < size; i++) {
	printf("%2d ", data[i]);
    }
    printf("\n");
}

/**
 * タスク終了後の data1, data2 の確認
 */
static void
twice_result(SchedTask *s, void *a, void *b)
{
    int* data = (int*)a;
    int* task_buf = (int*)b;
    print_data(data, length*task_array_num, "after");
    free(data);
    free(task_buf);
}

static int
init(int argc, char **argv)
{
    int block_size = 16;
    for (int i = 1; argv[i]; ++i) {
        if (strcmp(argv[i], "-task") == 0) {
            task = atoi(argv[++i]);
        } else if (strcmp(argv[i], "-task_array_num") == 0) {
            task_array_num = atoi(argv[++i]);
        } else if (strcmp(argv[i], "-block_num") == 0) {
            block_num = atoi(argv[++i]);
        } else if (strcmp(argv[i], "-block_size") == 0) {
            block_size = atoi(argv[++i]);
        }
    }
    length = task_array_num * block_num * block_size;

    return 0;
}

#if 0
static void print_ListData(int size, ListElement *t) 
{
    for(int i = 0;i<size;i++) {
	printf("ListData %d %d %lx\n",i,t[i].size,(unsigned long)t[i].addr);
    }
}
#endif

void
twice_init(TaskManager *manager,int *data, int length)
{


    for (int i = 0; i < length*task_array_num; i++) {
	data[i] = i;
    }

    print_data(data, length*task_array_num, "before");

    /**
     * Create Task
     *   create_task(Task ID);
     */ 

    HTask *twice_main = manager->create_task_array(Twice,task_array_num,block_num+1,block_num,block_num);
    Task *t = twice_main->next_task_array(Twice, 0);
#if 0
    printf("allocate task size 0x%0x\n",t->size());
    printf("allocate task total size 0x%0x = 0x%0x * %d\n",twice_main->r_size,
		t->size(), task_array_num);
#endif
    void *task_buf = twice_main->rbuf;
    twice_main->set_post(twice_result, (void*)data, task_buf);

    t = 0;
    for(int i = 0;i<task_array_num;i++) {
	t = twice_main->next_task_array(Twice, t);
	int block_size = length/block_num;
	t->set_param(0, (memaddr)block_num);

	for(int j = 0;j<block_num;j++) {
	    /**
	     * Set 32bits parameter
	     *   add_param(32bit parameter);
	     */
	    t->set_param(j+1, (memaddr)block_size);
	    /**
	     * Set of Input Data
	     *   add_inData(address of input data, size of input data);
	     */
	    t->set_inData(j,data, sizeof(int)*block_size);
	    /**
	     * Set of Output area
	     *   add_outData(address of output area, size of output area);
	     */
	    t->set_outData(j,data, sizeof(int)*block_size);
	    data += block_size;
	}
#if 0
	print_ListData(block_num,t->inData(0));
	print_ListData(block_num,t->outData(0));
	printf("pos 0x%0lx size 0x%0x\n",(unsigned long)t, t->size());
#endif
    }
    twice_main->spawn_task_array(t->next());

    twice_main->set_cpu(SPE_ANY);
    /*
     * set_post() で ppe task を渡せるようにしたい
     */
    // add Active Queue
    twice_main->spawn();    
}

int
TMmain(TaskManager *manager,int argc, char *argv[])
{
    if (init(argc, argv) < 0) {
	return -1;
    }

    // Task Register
    //   ppe/task_init.cc
    task_init();

    for (int i = 0; i < task; ++i) {
	int *data = (int*)manager->allocate(sizeof(int)*length*task_array_num);
	twice_init(manager, data, length);
    }

    return 0;
}
