#include "../Func.h"
#include "polygon.h"
#include "scene_graph_pack.h"
#include "polygon_pack.h"
#include "SpanPack.h"
#include "TaskManager.h"

extern TaskManager *manager;
extern int create_sgp(Polygon *sg, SceneGraphPack *sgp);
extern int update_sgp(SceneGraphPack *sgp, SceneGraphPack *_sgp);
extern int create_pp(SceneGraphPack *sgp, PolygonPack *pp);
extern int create_span(void *wbuf, void *rbuf);
extern int span_pack_draw(SpanPack *sp, unsigned int fbdev_addr);
extern int dummy(void* wbuf, void *rbuf);

/**
 * set_cpu(CPU_PPE) で動作する task
 */
void
task_initialize()
{
     manager->set_func(TASK_CREATE_SGP,  (SymTable::FuncObject)create_sgp);
     manager->set_func(TASK_UPDATE_SGP,  (SymTable::FuncObject)update_sgp);
     manager->set_func(TASK_CREATE_PP,   (SymTable::FuncObject)create_pp);
     manager->set_func(TASK_CREATE_SPAN,  create_span);
     manager->set_func(TASK_INIT_TEXTURE, dummy);
     //manager->set_func(TASK_DRAW, dummy);
     manager->set_func(TASK_DRAW, (SymTable::FuncObject)span_pack_draw);
}
