#include <malloc.h>
#include "CellScheduler.h"
#include "Load_Texture.h"
#include "error.h"
#include "SchedTask.h"
#include "TaskManager.h"
using namespace std;

#define height 128
#define width  128


int 
LoadTexture::run(void *rbuf , void *wbuf) 
{
	//int rgb;
     __debug("[LoadTexture:%s]\n", __FUNCTION__);
    __debug("%x\n",(int)rbuf);
    __debug("run\n");

    return 0;
}

// byteperpixel = 3 width = 128 dma_height= 32
#define LOAD_SIZE 3*128*32
#define MAX_LOAD_SIZE 16384      
#define USE_ARRAY 3

void 
LoadTexture::read(void) 
{
     __debug("[LoadTexture:%s]\n", __FUNCTION__);
#if 1
    connector->dma_load(readbuf,task->in_addr,MAX_LOAD_SIZE,DMA_READ);
    connector->dma_load((void*)((int)readbuf + MAX_LOAD_SIZE),
	          task->in_addr + MAX_LOAD_SIZE, MAX_LOAD_SIZE,DMA_READ + 1);
    connector->dma_load((void*)((int)readbuf + MAX_LOAD_SIZE*2) ,
          task->in_addr + MAX_LOAD_SIZE * 2,MAX_LOAD_SIZE,DMA_READ + 2);
    __debug("readbuf: %x\n", (uint32)readbuf);
    __debug("readbuf2:%x\n", (int)readbuf + MAX_LOAD_SIZE);
    __debug("readbuf3:%x\n", (int)readbuf + MAX_LOAD_SIZE*2);
#else 
	mfc_list_element buf[USE_ARRAY];
	for(int i = 0; i < USE_ARRAY; i++) {
		buf[i].notify = 0;
		buf[i].reserved = 0;
		buf[i].size = MAX_LOAD_SIZE;
		buf[i].eal = task->in_addr + i*MAX_LOAD_SIZE;
	}
	__debug("set_load_info\n");
	connector->dma_load(readbuf, (unsigned int)buf, MAX_LOAD_SIZE, DMA_READ);
	__debug("dma_load_finish\n");

#endif
}

void 
LoadTexture::write(void) 
{
     __debug("[LoadTexture:%s]\n",__FUNCTION__);
     connector->dma_wait(DMA_WRITE);
     connector->mail_write((uint32)task->self);
}

/*
Uint32 Polygon::get_rgb(int tx, int ty)
{
SDL_PixelFormat *fmt;
Uint8 red, green, blue;
	    
fmt = texture_image->format;

if (tx<0) tx = 0;
if (texture_image->w-1< tx) tx = texture_image->w-1 ;
if (ty<0) ty = 0;
if (texture_image->h-1< ty) ty = texture_image->h-1 ;



char *p = get_pixel(tx,ty,texture_image);
blue  = (Uint8) p[0];
green = (Uint8) p[1];
red   = (Uint8) p[2];
	            

SDL_PixelFormat *pf;
pf = viewer->screen->format;

//cout << SDL_MapRGB(pf, red, green, blue) << endl;
return SDL_MapRGB(pf, red, green, blue);
}
*/

SchedTask *
createTask_LoadTexture(TaskListPtr _taskList, TaskPtr _task,
		       void *rbuf, void *wbuf, DmaManager *dma) {
     CellScheduler::tex = memalign(DEFAULT_ALIGNMENT, DMA_MAX_SIZE*3);
     rbuf = CellScheduler::tex;

     return new LoadTexture(_taskList, _task, rbuf, wbuf, dma);
}
