#include <iostream>
#include "polygon_pack.h"
#include "scene_graph_pack.h"
#include "sys.h"
using namespace std;

#include "error.h"

int
create_pp(SceneGraphPack *sgp, PolygonPack *pp)
{
    float xyz1[4],xyz2[4],xyz3[4];

    __debug("[%s] sgp = 0x%x, pp = 0x%x\n", __FUNCTION__,
	    (unsigned int)sgp,(unsigned int)pp);

    for (int i = 0; i < sgp->info.size; i++) {
	SceneGraphNodePtr node = &sgp->node[i];
    
	int n,nt,pt;
	for(n=0,nt=0,pt=0; n<node->size*3; n+=9,nt+=6,pt++) {
	    xyz1[0] = node->vertex[n];
	    xyz1[1] = node->vertex[n+1];
	    xyz1[2] = node->vertex[n+2]*-1;
	    xyz1[3] = 1;
	    xyz2[0] = node->vertex[n+3];
	    xyz2[1] = node->vertex[n+3+1];
	    xyz2[2] = node->vertex[n+3+2]*-1;
	    xyz2[3] = 1;
	    xyz3[0] = node->vertex[n+6];
	    xyz3[1] = node->vertex[n+6+1];
	    xyz3[2] = node->vertex[n+6+2]*-1;
	    xyz3[3] = 1;

	    rotate(xyz1, node->translation);
	    rotate(xyz2, node->translation);
	    rotate(xyz3, node->translation);

	    pp->tri[pt].ver1.x = xyz1[0];
	    pp->tri[pt].ver1.y = xyz1[1];
	    pp->tri[pt].ver1.z = xyz1[2];
	    pp->tri[pt].ver1.tex_x = node->texture[nt];
	    pp->tri[pt].ver1.tex_y = node->texture[nt+1];

	    pp->tri[pt].ver2.x = xyz2[0];
	    pp->tri[pt].ver2.y = xyz2[1];
	    pp->tri[pt].ver2.z = xyz2[2];
	    pp->tri[pt].ver2.tex_x = node->texture[nt+2];
	    pp->tri[pt].ver2.tex_y = node->texture[nt+2+1];

	    pp->tri[pt].ver3.x = xyz3[0];
	    pp->tri[pt].ver3.y = xyz3[1];
	    pp->tri[pt].ver3.z = xyz3[2];
	    pp->tri[pt].ver3.tex_x = node->texture[nt+4];
	    pp->tri[pt].ver3.tex_y = node->texture[nt+4+1];

	    //pp->tri[pt].tex_addr = node->tex_addr;
	    pp->tri[pt].tex_width = node->tex_width;
	    pp->tri[pt].tex_height = node->tex_height;

	}
	pp->info.size = pt;
	pp->ssl = sgp->ssl;
    }
    return sizeof(PolygonPack);
}
