#include <iostream>
#include "viewer.h"
#include "polygon.h"
#include "demonstration.h"
#include "pad.h"
#include "TaskManager.h"
using namespace std;

#include "error.h"

int init(void*, void*);
int sdl_init(void*, void*);
int zrow_init(void*, void*);
int run(void*, void*);
int finish(void*, void*);

extern void task_initialize();

TaskManager *manager;
Viewer *screen;

struct init_arg {
    int bpp;
    int w;
    int h;
};

struct init_arg *initArg;

int init(void *r, void *w)
{
    int fd_sdl_init, fd_zrow_init, fd_run;
    HTaskPtr task_sdl_init, task_zrow_init, task_run;

    __debug("[%s]\n", __FUNCTION__);

    screen = new Viewer(initArg->bpp, initArg->w, initArg->h);

    fd_sdl_init  = manager->open("sdl_init");
    fd_zrow_init = manager->open("zRow_init");
    fd_run       = manager->open("run");

    task_sdl_init  = manager->create_task(fd_sdl_init, 0, 0, 0, NULL);
    task_zrow_init = manager->create_task(fd_zrow_init, 0, 0, 0, NULL);
    task_run       = manager->create_task(fd_run, 0, 0, 0, NULL);

    manager->set_task_depend(task_sdl_init, task_run);
    manager->set_task_depend(task_zrow_init, task_run);

    //task_sdl_init->set_depend(..);
    //task_sdl_init->spawn();

    manager->spawn_task(task_sdl_init);
    manager->spawn_task(task_zrow_init);
    manager->spawn_task(task_run);

    free(initArg);
    return 0;
}


// クラス関数は単純にポインタで扱えないので
// 現状は間接的に呼ぶことに
int sdl_init(void *r, void *w)
{
    __debug("[%s]\n", __FUNCTION__);
    screen->sdl_init();
    return 0;
}

int zRow_init(void *r, void *w)
{
    __debug("[%s]\n", __FUNCTION__);
    screen->zRow_init();
    return 0;
}

int run(void *r, void *w)
{
    __debug("[%s]\n", __FUNCTION__);
    screen->run_init();
    return 0;
}

int run_loop(void *r, void *w)
{
    __debug("[%s]\n", __FUNCTION__);
    screen->run_loop();
    return 0;
}

int run_draw(void *r, void *w)
{
    __debug("[%s]\n", __FUNCTION__);
    screen->run_draw();
    return 0;
}

int run_finish(void *r, void *w)
{
    __debug("[%s]\n", __FUNCTION__);
    screen->run_finish();
    return 0;
}

int finish(void *w, void *r)
{
    __debug("[%s]\n", __FUNCTION__);
    delete screen;
    delete manager;
    return 0;
}

int
main(int argc, char *argv[])
{
    manager = new TaskManager(1);
    manager->init();

    task_initialize();

    // 本当は、dlsym みたいなものを使いたいんだけど
    // 静的なやつはできないん？
    manager->set_symbol("init", (void*)init);
    manager->set_symbol("sdl_init", (void*)sdl_init);
    manager->set_symbol("zRow_init", (void*)zRow_init);
    manager->set_symbol("run", (void*)run);
    manager->set_symbol("finish", (void*)finish);
    manager->set_symbol("ViewerRunLoop", (void*)run_loop);
    manager->set_symbol("ViewerRunDraw", (void*)run_draw);
    manager->set_symbol("ViewerRunFinish", (void*)run_finish);

    int bpp = 0;
    int width = 640;
    int height = 480;

    for(int i = 1; argv[i]; ++i)
    {
	if (strcmp(argv[i], "-bpp") == 0)
	{
	    bpp = atoi(argv[++i]);
	}
	if (strcmp(argv[i], "-width") == 0)
	{
	    width = atoi(argv[++i]);
	} 
	if (strcmp(argv[i], "-height") == 0) 
	{
	    height = atoi(argv[++i]);
	}
    }

    // 一番最初に行われる init 専用の task_run があってもいいけど。。
    // その場合は引数とか固定か。まあ引数は argc, argv を持つ
    // 構造体で固定しても問題はない・・・か？
    HTaskPtr task_init;
    int fd_init;
    initArg = new struct init_arg;
    initArg->bpp = bpp;
    initArg->w = width;
    initArg->h = height;    

    fd_init = manager->open("init");
    task_init  = manager->create_task(fd_init, 0, 0, 0, NULL);
    manager->spawn_task(task_init);

    manager->run();

    finish(NULL, NULL);
    return 0;
}
