#!BPY
"""Registration info for Blender menus:
Name: 'Libps3 (from xml)'
Blender: 240
Group: 'Import'
Tooltip: 'Import to Blender for libps3'
"""

######################################################
# Importing modules
######################################################
import sys
from xml.sax import ContentHandler
from xml.sax import make_parser
import math
import os
import Blender
import struct
import base64
import inspect
from Blender import *
from Blender import sys as bsys, Mathutils, Draw, BGL
from Blender.Mathutils import Vector
from Blender.sys import *
import bpy

class SimpleHandler(ContentHandler):

    def __init__(self):
        self.meList = []
        self.objNames = []
        self.objNum = 0
        self.vi = 0
        self.name = ""
        self.coords = []

    def startElement(self, name, attrs):        
        if name == 'surface':  
            self.mesh = mesh_obj()
            mobj = self.mesh
            mobj.objName = attrs['name']
            mobj.objSize = int(attrs['size'])
            mobj.objPrim = attrs['prim']
            mobj.objParent = attrs['parent']
            self.meList.append(mobj)
            self.objNames.append(mobj.objName)
            self.objNum += 1
            self.vi = 0
        elif name == 'coordinate':
            self.name = name
        elif name == 'image':
            self.name = name
            #_imgName = attrs['name']
            #_imgFile = open(_imgName+".base", 'w')
            #_imgData = ""        
        else:
            self.name = ""

    #def endElement(self, name):
    #    global _name
        
    def characters(self, char):
        if self.name == 'coordinate':
            data = char.strip("\t\n\r")
            data = data.split(" ")
            sData = []
            if len(data) == 3:
                for i in range(3):
                    sData.append(float(data.pop(0))) # list [x, y, z] (type=float)
                self.coords.append(sData)
                
                if len(self.coords) == 3:                    
                    self.mesh.me.verts.extend(self.coords) # if three point prepared: add vertex ([[x,y,z],[x,y,z],[x,y,z]])
                    self.mesh.me.faces.extend([self.vi, self.vi+1, self.vi+2]) # make face between 3 vertex
                    self.vi += 3
                    self.coords = []
    
def create(handler):
    sc = bpy.data.scenes.active # get scene
    for i in range(handler.objNum):
        sc.objects.new(handler.meList[i].me, handler.objNames[i]) # add mesh objects to scene
        handler.meList[i].me.remDoubles(0.0) # remove double vertexs
    Window.RedrawAll()

def file_open(fileName):
    handler = SimpleHandler()
    parser = make_parser()
    f = open(fileName, 'rb')
    parser.setContentHandler(handler)
    parser.parse(f)
    create(handler)

class mesh_obj:
    def __init__(self):
        self.me = Mesh.New('')
        self.objName = ""
        self.objSize = 0
        self.objPrim = ""
        self.objParent = ""


Window.FileSelector(file_open, "Choose xml file")
