#include <stdlib.h>
#include "SceneGraphRoot.h"
#include "untitled.h"
#include <math.h>

static void
cubetest_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,
	       SceneGraphPtr tree)
{
}

static void
test_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,
	       SceneGraphPtr tree)
{
  // test
}

static void
test_move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{

  node->angle[0] += 10.0f;
  
}

static void
cubetest_move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
    node->angle[1] += 10.0f;
    if (node->angle[1] > 360.0f) {
	node->angle[1] = 0.0f;
    }
    node->xyz[0] += node->stack_xyz[0];
    if ((int)node->xyz[0] > screen_w || (int)node->xyz[0] < 0) {
	node->stack_xyz[0] = -node->stack_xyz[0];
    }

    node->xyz[1] += node->stack_xyz[1];
    if ((int)node->xyz[1] > screen_h || (int)node->xyz[1] < 0) {
	node->stack_xyz[1] = -node->stack_xyz[1];
    }

    node->xyz[2] = 100 ;
  
}

MainLoopPtr
untitled::init(Viewer *sgroot, int screen_w, int screen_h)
{
    SceneGraphPtr test00;
    SceneGraphPtr test01;
    SceneGraphPtr test02;
    SceneGraphPtr test03;
    SceneGraphPtr test04;
    SceneGraphPtr test05;
    SceneGraphPtr test06;
    SceneGraphPtr test07;
    SceneGraphPtr test08;
    SceneGraphPtr test09;

    sgroot->createFromXMLfile( "xml_file/Venus.xml");

    test00 = sgroot->createSceneGraph("Venus000");
    test01 = sgroot->createSceneGraph("Venus009");
    test02 = sgroot->createSceneGraph("Venus008");
    test03 = sgroot->createSceneGraph("Venus007");
    test04 = sgroot->createSceneGraph("Venus006");
    test05 = sgroot->createSceneGraph("Venus005");
    test06 = sgroot->createSceneGraph("Venus004");
    test07 = sgroot->createSceneGraph("Venus003");
    test08 = sgroot->createSceneGraph("Venus002");
    test09 = sgroot->createSceneGraph("Venus001");
    
    // SceneGraph の move と collision を設定
    test00->set_move_collision(cubetest_move, cubetest_collision);
    test00->stack_xyz[0] = 3.0f;
    test00->stack_xyz[1] = 3.0f;
    test00->stack_xyz[2] = 3.0f;
    
    test01->set_move_collision(test_move, test_collision);
    test02->set_move_collision(test_move, test_collision);
    test03->set_move_collision(test_move, test_collision);
    test04->set_move_collision(test_move, test_collision);
    test05->set_move_collision(test_move, test_collision);
    test06->set_move_collision(test_move, test_collision);
    test07->set_move_collision(test_move, test_collision);
    test08->set_move_collision(test_move, test_collision);
    test09->set_move_collision(test_move, test_collision);
    
    // SceneGraph 同士の親子関係を設定 (今回は 親 test00、子 その他)
    test00->addChild(test01);
    test00->addChild(test02);
    test00->addChild(test03);
    test00->addChild(test04);
    test00->addChild(test05);
    test00->addChild(test06);
    test00->addChild(test07);
    test00->addChild(test08);
    test00->addChild(test09);

    // SceneGraphRoot に、使用する SceneGraph を設定する
    // このとき、ユーザーが記述した SceneGraph の root を渡す。
    sgroot->setSceneData(test00);
    return sgroot;    
}

extern Application *
application() {
    return new untitled();
}

const char *usr_help_str = "Usage: ./test_nogl [OPTION]\n";

extern int init(TaskManager *manager, int argc, char *argv[]);
extern void task_initialize();
static void TMend(TaskManager *manager);

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    task_initialize();
    manager->set_TMend(TMend);
    return init(manager, argc, argv);

}

void
TMend(TaskManager *manager)
{
    printf("test_nogl end\n");
}

/* end */

