#include "SceneGraphRoot.h"
#include "vacuum.h"

extern int redcube;

void
title_collision(SceneGraphPtr node, void *sgroot_, int w, int h,SceneGraphPtr tree)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
  Pad *pad = sgroot->getController();
  
  if(pad->start.isPush()) {
    
    SceneGraphPtr vacuum;
    SceneGraphPtr back = sgroot->createSceneGraph(); 

    vacuum = sgroot->createSceneGraph("BIGCUBE");
    vacuum->xyz[0] = w/2;
    vacuum->xyz[1] = h*0.8;
    vacuum->set_move_collision(vacuum_move, vacuum_coll);
    
    back->addChild(vacuum);
    
    add_cubecollision_object(redcube,vacuum,w,h, sgroot);
    
    sgroot->setSceneData(back);
      
  }
}
