#include <stdio.h>
#include <stdlib.h>
#include "lindaapi.h"
#include "aquarium.pb.h"

int main(int argc, char *argv[]) {
	init_linda();
	srandom(time(0));
	aqua::Width *width = new aqua::Width();
	width->set_width(random() % 30);
	printf("send: %d\n", width->width());
	int size = width->ByteSize();
	unsigned char *msg = (unsigned char *) malloc(sizeof(char) * size);
	width->SerializeToArray(msg, size);

	int linda = open_linda_java("localhost", 10000);
	int seq = psx_update(linda, 1, msg, size);
	unsigned char *reply = NULL;
	while (true) {
		psx_sync_n();
		reply = psx_reply(seq);
		if (reply != NULL)
			break;
	}
	int len = psx_get_datalength(reply);
	if (len != 0) {
		width->ParseFromArray(reply + LINDA_HEADER_SIZE, len);
		printf("recv: %d\n", width->width());
	}
	delete width;
	
	return 0;
}
