#include <math.h>
#include <stdlib.h>
#include "SceneGraphRoot.h"
#include "MainLoop.h"
#include "property_universe.h"
#include "types.h"
#include "MyFunc.h"
#include "matrix_calc.h"
#include "SgChange.h"

static const int PROPERTY_LENGTH = 2;

Property *property, *update_property;

// prototype
static void collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h, SceneGraphPtr tree);
static void move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h);
static void createSceneGraphFromProperty(SchedTask *s, void *sgroot, void *arg1);
static void set_property(Property *p, SceneGraphPtr sg, int index);
static void apply_property(SceneGraphPtr sg, Property *p);
static void regist_task(SceneGraphRoot *sgroot);
static void set_relation(SceneGraphPtr parent, SceneGraphPtr child);

static void
move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
    HTaskPtr property_task = sgroot->move_exec_task;

    property_task->add_inData(property, sizeof(Property)*PROPERTY_LENGTH);
    property_task->add_outData(update_property, sizeof(Property)*PROPERTY_LENGTH);
    property_task->set_cpu(SPE_ANY);    
    property_task->set_post(createSceneGraphFromProperty, (void *)sgroot, 0);
    property_task->spawn();
}

static void
collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,
	  SceneGraphPtr tree)
{
}

static void
createSceneGraphFromProperty(SchedTask *s, void *sgroot_, void *arg1)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
    SceneGraphPtr camera = sgroot->camera;
    SceneGraphPtr p_node;
    
    // ここが allExecute の tree をたどって clone して行くところに相当する
    Property *p;
    
    for (int i = 0; i < PROPERTY_LENGTH; i++) {
	p = &update_property[i];
	SceneGraphPtr node = sgroot->createSceneGraph(p->name);
	if (strcmp(node->name, "Earth") == 0) {
	    node->set_move_collision(move, collision);
	}
	apply_property(node, p);    
    }
	
    for (int j = 0; j < PROPERTY_LENGTH; j++) {
	p = &update_property[j];
	p_node = (SceneGraphPtr)p->node;
	//float scale[] = {1,1,1};
	if (p->have_parent) {
	    SceneGraphPtr parent = (SceneGraphPtr)update_property[p->parent_index].node;
	    parent->addChild(p_node);
	    get_matrix(p_node->matrix, p_node->angle, p_node->xyz, parent->matrix);
	    get_matrix(p_node->real_matrix, p_node->angle, p_node->xyz, parent->real_matrix);
	} else {
	  get_matrix(p_node->matrix, p_node->angle, p_node->xyz, camera->matrix);
	  get_matrix(p_node->real_matrix, p_node->angle, p_node->xyz, camera->real_matrix);
	}
    }

    sgroot->setSceneData((SceneGraphPtr)update_property[0].node);

    Property *tmp = property;
    property = update_property;
    update_property = tmp;

    sgroot->move_finish();
}

static void
apply_property(SceneGraphPtr node, Property *p)
{
    for (int i = 0; i < 3; i++) {
	node->xyz[i] = p->xyz[i];
	node->angle[i] = p->angle[i];
	node->stack_xyz[i] = p->stack_xyz[i];
    }
    p->node = (memaddr)node;
    node->property = (memaddr)p;
}

/*
  ここで必要な値をプロパティに格納
 */
static void
set_property(Property *p, SceneGraphPtr node, int index)
{
    for (int i = 0; i < 3; i++) {
	p->xyz[i] = node->xyz[i];
	p->angle[i] = node->angle[i];
	p->stack_xyz[i] = node->stack_xyz[i];
    }
    p->parent = (memaddr)node->parent;
    p->children = (memaddr)node->children;
    p->name = node->name;
    p->property_index = index;    
    
    p->node = (memaddr)node;
    node->property = (memaddr)p;
}

static void
regist_task(SceneGraphRoot *sgroot)
{
    TaskManager *manager = sgroot->tmanager;
    HTaskPtr task = manager->create_task(UniverseTask);
    // sgroot->setExecTask(task); とやるべき？
    sgroot->move_exec_task = task;
}

static void
set_relation(SceneGraphPtr parent, SceneGraphPtr child)
{
    /*
    child->property->parent_index = parent->property->property_index;
    child->property->have_parent = 1;
    */

    Property *p = (Property *)parent->property;
    Property *c = (Property *)child->property;
    c->parent_index = p->property_index;
    c->have_parent = 1;

}

MainLoopPtr 
property_universe::init(Viewer *viewer, int screen_w, int screen_h)
{
    // SgChange を使うための2行
    SgChange *sgroot = new SgChange(viewer);
    sgroot->run_init();
    // 上で書いた regist_task() を登録
    // sgroot->appTaskRegist(regist_task); がいいかな
    sgroot->sgroot_A->appTaskRegist(regist_task);

    int root_obj_index = 0;
    property        = (Property *)sgroot->manager->allocate(sizeof(Property)*PROPERTY_LENGTH);
    update_property = (Property *)sgroot->manager->allocate(sizeof(Property)*PROPERTY_LENGTH);

    SceneGraphPtr earth;
    sgroot->createFromXMLfile("xml_file/universe.xml");
    earth = sgroot->createSceneGraph("Earth");
    earth->set_move_collision(move, collision);
    earth->xyz[0] = screen_w / 2;
    earth->xyz[1] = screen_h / 2;

    SceneGraphPtr moon;
    moon = sgroot->createSceneGraph("Moon");

    earth->addChild(moon);

    set_property(&property[root_obj_index], earth, 0);
    set_property(&property[1], moon, 1);
    set_relation(earth, moon);
    
    sgroot->setSceneData(earth);

    return sgroot;
}

extern Application *
application() {
    return new property_universe();
}

const char *usr_help_str = "Usage: ./test_nogl [OPTION]\n";

extern int init(TaskManager *manager, int argc, char *argv[]);
extern void task_initialize();
static void TMend(TaskManager *manager);

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    task_initialize();
    manager->set_TMend(TMend);
    return init(manager, argc, argv);

}

void
TMend(TaskManager *manager)
{
    printf("test_nogl end\n");
}

/* end */
