
#include "SgChange.h"

typedef void (*spe_move_func)(void *cv, int screen_w, int screen_h);
typedef void (*spe_collision_func)(void *cv, int screen_w, int screen_h);

typedef struct {
    double x, y, next_x, next_y;
    double vx, vy, next_vx, next_vy;
    double angle[3];
    int can_move;
    int id;
    const char *objname;
    spe_move_func move;
    spe_collision_func collision;
    SceneGraphPtr parent;
    SceneGraphPtr root;
} *ChainPropertyPtr, ChainProperty;

#define FALSE 0
#define TRUE !FALSE
#define CHAIN_LEN 50

static const double m = 100.0;
static const double k = 7000.0;
static const double g = 9.8;
static const double dt = 0.003;
static const double chain_width = 10;
static const double safe = 0.995;

class Chain : public Application {
public:
    Chain(){}

    SceneGraphPtr scenegraph_factory(void *p, int size);
    SceneGraphPtr scenegraph_connector(void *p, int size, SceneGraphPtr s, SceneGraphPtr sg_available_list);
    void init(TaskManager *manager, int w, int h);
    void init_chain_vars(ChainPropertyPtr cv);
    void chain_move(TaskManager *manager, SceneGraphPtr sg, int w, int h);
    //void chain_collision(SceneGraphPtr sg, int w, int h, SceneGraphPtr osg);
    void chain_collision(ChainPropertyPtr cv, int w, int h);
    //void createSceneGraphFromProperty(SceneGraphPtr root, ChainPropertyPtr cv, Viewer *sgroot);
    //void property_swich();
    //void set_properties(ChainPropertyPtr cv);
    MainLoopPtr init(Viewer *viewer, int screen_w, int screen_h);


};
