#include "SceneGraph.h"
#include "hit_judge.h"
#include "SGList.h"

#define FUSELAGE_W 6
#define FUSELAGE_H 6
#define FUSELAGE_Z 6
#define E_PLANE_W 6*4
#define E_PLANE_H 6*4
#define E_PLANE_Z 6*4
#define BULLTE_W 2*4
#define BULLTE_H 6*4
#define BULLTE_Z 2*4

int 
square_judge(SceneGraphPtr oneself, SceneGraphPtr partner)
{
  int ow = 0, oh = 0, oz = 0;
  int pw = 0, ph = 0, pz = 0;
  if (oneself->sgid == IDLE)
    {
      ow = FUSELAGE_W;
      oh = FUSELAGE_H;
      oz = FUSELAGE_Z;
    }
  else if (oneself->sgid == E_PLANE)
    {
      ow = E_PLANE_W;
      oh = E_PLANE_H;
      oz = E_PLANE_Z;
    }
  else if(oneself->sgid == BULEBULLET)
    {
      ow = BULLTE_W;
      oh = BULLTE_H;
      oz = BULLTE_Z;
    }
  if(partner->sgid == IDLE)
  {
	pw = FUSELAGE_W;
	ph = FUSELAGE_H;
	pz = FUSELAGE_Z;
  }
  else if(partner->sgid == E_PLANE)
  {
      pw = E_PLANE_W;
      ph = E_PLANE_H;
      pz = E_PLANE_Z;
  }
  else if(partner->sgid == BULEBULLET)
    {
      pw = BULLTE_W;
      ph = BULLTE_H;
      pz = BULLTE_Z;
    }


  int ox_min = (int)(oneself->xyz[0] + oneself->c_xyz[0] - ow/2);
  int oy_min = (int)(oneself->xyz[1] + oneself->c_xyz[1] - oh/2);
  int oz_min = (int)(oneself->xyz[2] + oneself->c_xyz[2] - oz/2);

  int ox_max = (int)(oneself->xyz[0] + oneself->c_xyz[0] + ow/2);
  int oy_max = (int)(oneself->xyz[1] + oneself->c_xyz[1] + oh/2);
  int oz_max = (int)(oneself->xyz[2] + oneself->c_xyz[2] + oz/2);

  int px_min = (int)(partner->xyz[0] + partner->c_xyz[0] - pw/2);
  int py_min = (int)(partner->xyz[1] + partner->c_xyz[1] - ph/2);
  int pz_min = (int)(partner->xyz[2] + partner->c_xyz[2] - pz/2);

  int px_max = (int)(partner->xyz[0] + partner->c_xyz[0] + pw/2);
  int py_max = (int)(partner->xyz[1] + partner->c_xyz[1] + ph/2);
  int pz_max = (int)(partner->xyz[2] + partner->c_xyz[2] + pz/2);

  if(ox_max < px_min || px_max < ox_min || oy_max < py_min || py_max < oy_min || oz_max < pz_min || pz_max < oz_min)
  {
  }  else {
      return HIT;
  }
  return 0;
}
