#include "SceneGraphRoot.h"
#include "gaplant_action.h"
#include "gaplant.h"
#include "back_action.h"

MainLoopPtr
gaplant::init(Viewer *sgroot, int w, int h)
{
    SceneGraphPtr back;
    SceneGraphPtr gaplant;
    sgroot->createFromXMLfile("xml_file/gap_plane_test.xml");
    sgroot->createFromXMLfile("xml_file/Ball.xml");

    sgroot->OnLightSysSwitch();

    back = sgroot->createSceneGraph();
    back->set_move_collision(back_move, back_coll);
    gaplant = sgroot->createSceneGraph();
    gaplant->xyz[0] = w / 2;
    gaplant->xyz[1] = h / 2;

    gaplant->angle[0] = -60;
    gaplant->angle[1] = 0;
    gaplant->angle[2] = 0;
    gaplant->set_move_collision(gaplant_move, gaplant_coll);

    int foot =  sgroot->getSgid("chest_center_B");
    for (int i = sgroot->getSgid("chest_center_B.074"); i <= foot; i++) {
	SceneGraphPtr p = sgroot->createSceneGraph(i);
	gaplant->addChild(p);
    }

    back->addChild(gaplant);
    sgroot->setSceneData(back);        
    return sgroot;
}

extern Application *
application() {
    return new gaplant();
}

const char *usr_help_str = "Usage: ./test_nogl [OPTION]\n";

extern int init(TaskManager *manager, int argc, char *argv[]);
extern void task_initialize();
static void TMend(TaskManager *manager);

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    task_initialize();
    manager->set_TMend(TMend);
    return init(manager, argc, argv);

}

void
TMend(TaskManager *manager)
{
    printf("test_nogl end\n");
}

/* end */
