#include "SceneGraphRoot.h"
#include "vacuum.h"


void
gameover_scene(int w,int h,SceneGraphPtr node, SceneGraphRoot *sgroot)
{
  SceneGraphPtr over;

  over = sgroot->createSceneGraph("GAMEOVER");
  over->xyz[0] = w/2;
  over->xyz[1] = h/2;
  over->set_move_collision(gameover_idle,gameover_collision);
  node->addBrother(over);
}

void
gameover_idle(SceneGraphPtr node, void *sgroot_, int screen_w,int screen_h)
{
}

void
gameover_collision(SceneGraphPtr node, void *sgroot_, int screen_w,int screen_h,SceneGraphPtr tree)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
  Pad *pad = sgroot->getController();

  if(pad->start.isPush()) {

    SceneGraphPtr title;

    title = sgroot->createSceneGraph("TITLE");
    title->xyz[0] = screen_w/2;
    title->xyz[1] = screen_h/2;
    title->set_move_collision(no_move_idle, title_collision);
    sgroot->setSceneData(title);

  }

}
