#include <math.h>
#include "SceneGraph.h"
#include "enemy_action.h"

#define PI M_PI

double vx = 5.0;

void 
enemy_move(SceneGraphPtr node, int screen_w, int screen_h)
{
  double vxr = (node->xyz[0])*PI/180;
  if(node->xyz[0] > screen_w/2 || node->xyz[0] < -screen_w/2) 
    {
      vx *= -1;
    }
  //printf("%f\n", vx);
  node->angle[1]+=vx;
  
  node->xyz[0] += vx;
  node->xyz[1] = -sin(vxr*2)*20*vx;
  node->xyz[2] = sin(vxr*4)*2*vx;
}


void
enemy_collision(SceneGraphPtr node, int screen_w, int screen_h, SceneGraphPtr tree)
{
#if 0
  int judge = square_judge(E_PLANE, BULEBULLET, tree);
  if(judge == HIT)
    {
      E_PLANE->set_move_collision(null_move, enemy_collision);
      printf("ENEMY_hit!!!＼n");
      //scene_graph->delete_object(node, node->next,node->prev);
    }
#endif
}
