#include <math.h>
#include "SceneGraphRoot.h"
#include "SGList.h"

static void cube_move_left(SceneGraphPtr node, int screen_w, int screen_h);
static void cube_move_right(SceneGraphPtr node, int screen_w, int screen_h);
static void cube_move_idle(SceneGraphPtr node, int screen_w, int screen_h);
static void cube_collision(SceneGraphPtr node, int screen_w, int screen_h,
			   SceneGraphPtr tree);

static void cube_split(SceneGraphPtr root);

static void
cube_move_left(SceneGraphPtr node, int screen_w, int screen_h)
{
    node->xyz[0] -= node->stack_xyz[0];
    node->xyz[1] -= node->stack_xyz[0] * node->stack_xyz[1];
    node->xyz[2] -= node->stack_xyz[0] * node->stack_xyz[2];

    if (node->xyz[0] < 0) {
	node->set_move_collision(cube_move_right, cube_collision);
    }

    if (node->xyz[1] < 0 || node->xyz[1] > screen_h) {
	node->stack_xyz[1] = -node->stack_xyz[1];
    }

    node->angle[0] += 2.0f;
    node->angle[1] += 2.0f * node->stack_xyz[1];
    node->angle[2] += 2.0f * node->stack_xyz[2];

    node->angle[0] = fmodf(node->angle[0], 360.0f);
    node->angle[1] = fmodf(node->angle[1], 360.0f);
    node->angle[2] = fmodf(node->angle[2], 360.0f);
    
    if (node->frame > 10 && sgroot->controller->circle.isPush()) {
	cube_split(node);
    }
}

static void
cube_move_right(SceneGraphPtr node, int screen_w, int screen_h)
{
    node->xyz[0] += node->stack_xyz[0];
    node->xyz[1] -= node->stack_xyz[0] * node->stack_xyz[1];
    node->xyz[2] -= node->stack_xyz[0] * node->stack_xyz[2];

    if (node->xyz[0] > screen_w) {
	node->set_move_collision(cube_move_left, cube_collision);
    }

    if (node->xyz[1] < 0 || node->xyz[1] > screen_h) {
	node->stack_xyz[1] = -node->stack_xyz[1];
    }

    node->angle[0] += 2.0f;
    node->angle[1] += 2.0f * node->stack_xyz[1];
    node->angle[2] += 2.0f * node->stack_xyz[2];

    node->angle[0] = fmodf(node->angle[0], 360.0f);
    node->angle[1] = fmodf(node->angle[1], 360.0f);
    node->angle[2] = fmodf(node->angle[2], 360.0f);

    if (node->frame > 10 && sgroot->controller->circle.isPush()) {
	cube_split(node);
    }
}

static void
cube_split(SceneGraphPtr root)
{
    SceneGraphPtr p = root->clone();
    root->addBrother(p);

    root->set_move_collision(cube_move_left, cube_collision);
    p->set_move_collision(cube_move_right, cube_collision);
 
    p->xyz[0] = root->xyz[0] + 2;
    p->xyz[1] = root->xyz[1];
    p->xyz[2] = root->xyz[2];

    p->stack_xyz[0] = 2.0f;
    p->stack_xyz[1] = random()%3-1;
    p->stack_xyz[2] = random()%3-1;

    root->xyz[0] -= 2;
    root->stack_xyz[0] = 2.0f;
    root->stack_xyz[1] = random()%3-1;
    root->stack_xyz[2] = random()%3-1;
}


static void
cube_move_idle(SceneGraphPtr node, int screen_w, int screen_h)
{
    node->xyz[0] = screen_w/2;
    node->xyz[1] = screen_h/2;
    //node->xyz[2] = -300.0f;

    if (sgroot->controller->circle.isPush()) {
	cube_split(node);
    }
}

static void
cube_collision(SceneGraphPtr node, int screen_w, int screen_h,
	       SceneGraphPtr tree)
{
}

void
create_cube_split(TaskManager *manager, int number)
{
    SceneGraphPtr cube;
    SceneGraphPtr back;

    sgroot->createFromXMLfile(manager, "xml_file/cube.xml");

    // 何もしない親
    // cube は brother として繋がっていくので
    // 親が居ないとだめ。
    back = sgroot->createSceneGraph();

    cube = sgroot->createSceneGraph(Cube);
    cube->xyz[0] = 960.0f;
    cube->xyz[1] = 540.0f;
    cube->set_move_collision(cube_move_idle, cube_collision);

    back->addChild(cube);

    sgroot->setSceneData(back);
}
