#include <iostream>
#include <math.h>
#include "SceneGraphRoot.h"
#include "SceneGraph.h"
#include "TaskManager.h"
#include "Chain.h"
#include "Func.h"


#define FALSE 0
#define TRUE !FALSE
#define CHAIN_LEN 50

static double m = 100.0;
static double k = 7000.0;
static double g = 9.8;
static double dt = 0.003;
static double chain_width = 10;
static double safe = 0.995;

typedef struct {
    double x, y, next_x, next_y;
    double vx, vy, next_vx, next_vy;
    int can_move;
} CHAIN_VARS;

CHAIN_VARS cv[CHAIN_LEN];

void
init_chainold_vars(CHAIN_VARS *cv) {
    cv->x = 0, cv->y = 0, cv->next_x = 0, cv->next_y = 0;
    cv->vx = 0, cv->vy = 0, cv->next_vx = 0, cv->next_vy = 0;
    cv->can_move = TRUE;
}

void
set_old_vector(CHAIN_VARS *cv, SceneGraphPtr sg) {
    sg->xyz[0] = (float)cv->next_x;
    sg->xyz[1] = (float)cv->next_y;
    sg->xyz[2] = 0.0f;
}


static void
chain_old_move_ope(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
    Pad *pad = sgroot->getController();

    if (pad->start.isHold()) {
        cv[CHAIN_LEN-1].can_move = FALSE;
        if (pad->left.isHold()) {
            cv[CHAIN_LEN-1].x += -5.0;
        } else if (pad->right.isHold()) {
            cv[CHAIN_LEN-1].x += 5.0;
        }

        if (pad->up.isHold()) {
            cv[CHAIN_LEN-1].y += -5.0;
        } else if (pad->down.isHold()) {
            cv[CHAIN_LEN-1].y += 5.0;
        }
    } else {
        cv[CHAIN_LEN-1].can_move = TRUE;
    }
}

void
chain_old_move(SceneGraphPtr sg, void *sgroot_, int w, int h)
{

    int id = sg->id;
    if(id == 0) {
        for(int cnt = 0; cnt < 600; cnt++) {
            for(int i = 0; i < CHAIN_LEN; i++) {
                if(cv[i].can_move) {
                    double dx = cv[i-1].x - cv[i].x;
                    double dy = cv[i-1].y - cv[i].y;
                    double l = sqrt(dx * dx + dy * dy);
                    double a = k * (l - chain_width) / m;
                    double ax = a * dx / l;
                    double ay = a * dy / l;
                    if(i < CHAIN_LEN - 1) {
                        dx = cv[i+1].x - cv[i].x;
                        dy = cv[i+1].y - cv[i].y;
                        l = sqrt(dx * dx + dy * dy);
                        a = k * (l - chain_width) / m;
                        ax += a * dx / l;
                        ay += a * dy / l;
                    }
                    ay += g;
                    cv[i].vx *= safe;
                    cv[i].vy *= safe;
                    cv[i].next_vx = cv[i].vx + ax * dt;
                    cv[i].next_vy = cv[i].vy + ay * dt;
                    cv[i].next_x = cv[i].x + cv[i].vx * dt;
                    cv[i].next_y = cv[i].y + cv[i].vy * dt;
                } else {
                    cv[i].next_x = cv[i].x;
                    cv[i].next_y = cv[i].y;
                }
            }
            for(int i = 0; i < CHAIN_LEN; i++) {
                cv[i].vx = cv[i].next_vx;
                cv[i].vy = cv[i].next_vy;
                cv[i].x = cv[i].next_x;
                cv[i].y = cv[i].next_y;
            }
        }
        //    cout << id << ", " << sg->xyz[1] << endl;
    }
    set_old_vector(&cv[id], sg);
    int p, n;
    p = n = id;
    if(p != 0) {
        p--;
    }
    if(n != CHAIN_LEN - 1) {
        n++;
    }
    sg->angle[2-(id%2)*2]
        = 90 + atan((cv[p].next_y - cv[n].next_y) / (cv[p].next_x - cv[n].next_x)) * 180 / M_PI;
}

void
chain_old_collision(SceneGraphPtr sg, void *sgroot_, int w, int h, SceneGraphPtr osg)
{

}

MainLoopPtr
Chain::init(Viewer *sgroot, int w, int h)
{
    SceneGraphPtr root_old_chain, chain;
    CHAIN_VARS rcv;

    sgroot->createFromXMLfile("xml_file/chain.xml");

    root_old_chain = sgroot->createSceneGraph("CHAIN");
    root_old_chain->set_move_collision(chain_old_move_ope, chain_old_collision);
    init_chainold_vars(&rcv);
    rcv.next_x = w / 2;
    rcv.next_y = 0.0;
    set_old_vector(&rcv, root_old_chain);

    for(int i = 0; i < CHAIN_LEN; i++) {
        chain = sgroot->createSceneGraph("CHAIN");
        chain->id = i;
        init_chainold_vars(&cv[i]);
        cv[i].x = 0;
        cv[i].y = chain_width * i;
        set_old_vector(&cv[i], chain);
        chain->angle[1] = -90 * (i % 2);
        chain->set_move_collision(chain_old_move, chain_old_collision);

        root_old_chain->addChild(chain);
    }
    cv[0].can_move = FALSE;

    sgroot->setSceneData(root_old_chain);
    return sgroot;
}

extern Application *
application() {
    return new Chain();
}

const char *usr_help_str = "Usage: ./test_nogl [OPTION]\n";

extern int init(TaskManager *manager, int argc, char *argv[]);
extern void task_initialize();
static void TMend(TaskManager *manager);

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    task_initialize();
    manager->set_TMend(TMend);
    return init(manager, argc, argv);

}

void
TMend(TaskManager *manager)
{
    printf("test_nogl end\n");
}

/* end */

