#include "SceneGraphRoot.h"
#include "SGList.h"
#include "camera_action.h"

#define MOVE_SPEED 0.10

void
camera_init(SceneGraphPtr node, int screen_w, int screen_h)
{
    node->xyz[0] = screen_w/2;
    node->xyz[1] = screen_h/2 + 50;
    node->xyz[2] = 0;
    node->angle[0] = 120;
}

void
c_move(SceneGraphPtr node, int screen_w, int screen_h)
{
    Pad *pad = sgroot->getController();

    if(pad->right.isHold())
    {
	if(node->xyz[0]>screen_w/2 - 50)
	{
          node->xyz[0]-=MOVE_SPEED;
        }
    }

    if(pad->left.isHold())
    {
      if(node->xyz[0]<screen_w/2 + 50)
        {
          node->xyz[0]+=MOVE_SPEED;
        }
    }

  if(pad->down.isHold())
    {
      if(node->xyz[2]>-25)
        {
          node->xyz[2]-=MOVE_SPEED;
        }
    }

  if(pad->up.isHold())
  {
      if(node->xyz[2]<25)
      {
          node->xyz[2]+=MOVE_SPEED;
      }
  }

}

void
camera_collision(SceneGraphPtr node, int screen_w, int screen_h,SceneGraphPtr tree)
{
}
