#include "SceneGraphRoot.h"
#include "MainLoop.h"
#include "boss1_action.h"

/*
static void
null_move(SceneGraphPtr node, int screen_w, int screen_h)
{
}
*/

static void
null_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,
	       SceneGraphPtr tree)
{
}


static void
boss1_move_right(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h) {
  node->xyz[0] += node->stack_xyz[0];
  if(node->xyz[0] > (screen_w - boss_radius_x)) {
    node->set_move_collision(boss1_move_left, null_collision);
  }
}

//ボスが左に移動する動作
static void
boss1_move_left(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h) {
  node->xyz[0] -= node->stack_xyz[0];
  if(node->xyz[0] < boss_radius_x) {
    node->set_move_collision(boss1_move_right, null_collision);
  }
}

//ボスが戦闘位置へ戻る時の動作
/*
static void
boss1_move_return(SceneGraphPtr node, int screen_w, int screen_h)
{
  node->xyz[1] -= node->stack_xyz[1];
  node->xyz[2] -= node->stack_xyz[2];

  if((node->xyz[2] = 0)) {
    node->stack_xyz[0] = 1.0;
    node->set_move_collision(boss1_move_left, null_collision);
  }
}
*/

//ボス登場時の動き
/*
static void
boss1_first_move(SceneGraphPtr node, int screen_w, int screen_h)
{
  node->xyz[1] += node->stack_xyz[1];
  if(node->xyz[1] > screen_h) {
    float time = first_boss1_depth / node->stack_xyz[2];
    node->stack_xyz[1] = (screen_h - boss_radius_y) / time;
    node->stack_xyz[2] = return_boss1_depth_speed;
    node->set_move_collision(boss1_move_return, null_collision);
  }
}
*/

static void
player_move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
  Pad *pad = sgroot->getController();
  
  if (pad->left.isPush()
      || pad->left.isHold()) {
#if 0
    SceneGraphPtr player_left;
    player_left =  sgroot->createSceneGraph(PLAYER_L);
    player_left->set_move_collision(player_move_left, null_collision);
    player_left->xyz[0] = node->xyz[0];
    player_left->xyz[1] = node->xyz[1];
    node->addChild(player_left);
    node->flag_drawable = 1;
#endif
    node->xyz[0] -= player_speed;
    
    if (node->xyz[0] - player_radius< 0) {
      node->xyz[0] = player_radius;
    }
  }
  
  
  if (pad->right.isPush()
      || pad->right.isHold()) {
    node->xyz[0] += player_speed;
    
    if (node->xyz[0] + player_radius > screen_w) {
      node->xyz[0] = screen_w - player_radius;
    }
  }
  
  if (pad->up.isPush()
      || pad->up.isHold()) {
    node->xyz[1] -= player_speed;
    
    if (node->xyz[1] - player_radius < 0) {
      node->xyz[1] = player_radius;
    }
  }
  
  if (pad->down.isPush()
      || pad->down.isHold()) {
    node->xyz[1] += player_speed;
    
    if (node->xyz[1] + player_radius > screen_h) {
      node->xyz[1] = screen_h - player_radius;
    }
  }
  
  if (pad->circle.isPush()) {
    SceneGraphPtr shot = sgroot->createSceneGraph("P_SHOT1");
    shot->set_move_collision(shot_move, shot_collision);
    shot->xyz[0] = node->xyz[0];
    shot->xyz[1] = node->xyz[1] - player_radius;
    node->addBrother(shot);
  }    
}

static int boss1sgid;

static void
player_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,
		 SceneGraphPtr tree)
{
    
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
  //自機とボスのx,y座標での距離と2点間の距離
  static float x_distant, y_distant, distance;
  //ボスの四角形の四隅の座標
  //  static float boss_low_x, boss_low_y, boss_high_x, boss_high_y;
  
  SceneGraphIteratorPtr it = sgroot->getIterator(tree);
  
  
  for (; it->hasNext(boss1sgid);) {
    it->next(boss1sgid);
    SceneGraphPtr enemy = it->get();
    
    //各変数の初期化
    x_distant = node->xyz[0] - enemy->xyz[0];
    y_distant = node->xyz[1] - enemy->xyz[1];
    
    //hypotfで2点間の距離を求める
    distance = hypotf(x_distant, y_distant);
    
    /*四角形と円のcollision
    if( (fabs( node->xyz[1] - ( boss_low_y )))
    */
    
    //円同士のcollision
    if(distance < (player_radius + boss_radius_y)) {
      printf("!!!CAUTION!!!\n");
    }
  }
}

static void
shot_move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
  node->xyz[1] -= shot_speed;
  
  // 描画領域から抜けたら削除
  if (node->xyz[1] < 0) {
    node->remove();
  }
}

static void
shot_collision(SceneGraphPtr node, void *sgroot_, int screen_2, int screen_h,
	       SceneGraphPtr tree)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
  //自機とボスのx,y座標での距離と2点間の距離
  static float x_distant, y_distant, distance;
  //ボスの四角形の四隅の座標
  //  static float boss_low_x, boss_low_y, boss_high_x, boss_high_y;
  
  SceneGraphIteratorPtr it = sgroot->getIterator(tree);
  
  
  for (; it->hasNext(boss1sgid);) {
    it->next(boss1sgid);
    SceneGraphPtr enemy = it->get();
    
    x_distant = node->xyz[0] - enemy->xyz[0];
    y_distant = node->xyz[1] - enemy->xyz[1];
    
    //hypotfで2点間の距離を求める
    distance = hypotf(x_distant, y_distant);
    
    //円同士のcollision
    if(distance <  boss_radius_y) {
      SceneGraphPtr blast = sgroot->createSceneGraph("BLAST1");
      
      blast->set_move_collision(blast_move, null_collision);
      blast->xyz[0] = node->xyz[0];
      blast->xyz[1] = node->xyz[1];
      node->addBrother(blast);
      node->remove();
    }
  }
}

extern Application *
application() {
    return new boss1_action();
}

const char *usr_help_str = "Usage: ./test_nogl [OPTION]\n";

static int blast8;

static void
blast_move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;

  if(node->sgid > blast8) {
    SceneGraphPtr blast = sgroot->createSceneGraph(node->sgid - 1);
    blast->set_move_collision(blast_move, null_collision);
    blast->xyz[0] = node->xyz[0];
    blast->xyz[1] = node->xyz[1];
    node->addBrother(blast);
  }
  
  if (node->sgid == blast8) {
    node->flag_drawable = 1;
  }
  
  if((node->frame > 1)) {
    node->remove();
  }
  node->frame += 1;
}
  
MainLoopPtr
boss1_action::init(Viewer *sgroot, int screen_w, int screen_h)
{

  sgroot->createFromXMLfile("xml_file/boss1.xml");
  sgroot->createFromXMLfile("xml_file/player1.xml");
  sgroot->createFromXMLfile("xml_file/p_shot.xml");
  sgroot->createFromXMLfile("xml_file/blast.xml");
 
  blast8 = sgroot->getSgid("BLAST8");
 
  //rootとなるSceneGraphを生成
  SceneGraphPtr root = sgroot->createSceneGraph();
  
  //自機の初期化
  SceneGraphPtr player = sgroot->createSceneGraph("PLAYER");
  player->xyz[0] = screen_w/2;
  player->xyz[1] = screen_h - player_radius;
  root->addChild(player);

  //ボスの初期化
  SceneGraphPtr boss1 = sgroot->createSceneGraph("BOSS1");
  boss1sgid = boss1->sgid;

  boss1->xyz[0] = screen_w/2;
  boss1->xyz[1] = boss_radius_y;
  //  boss1->xyz[2] = first_boss1_depth;
  boss1->stack_xyz[0] = first_boss1_speed;
  root->addChild(boss1);

  //ボスの左右パーツを追加
  SceneGraphPtr left_parts = sgroot->createSceneGraph("BOSS1_L");
  boss1->addChild(left_parts);
  SceneGraphPtr right_parts = sgroot->createSceneGraph("BOSS1_R");
  boss1->addChild(right_parts);

  //各機体の動きと当たり判定をセット
  player->set_move_collision(player_move, player_collision);  
  boss1->set_move_collision(boss1_move_left, null_collision);
  
  //仕上げ
  sgroot->setSceneData(root);
    return sgroot;
}

extern int init(TaskManager *manager, int argc, char *argv[]);
extern void task_initialize();
static void TMend(TaskManager *manager);

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    task_initialize();
    manager->set_TMend(TMend);
    return init(manager, argc, argv);

}

void
TMend(TaskManager *manager)
{
    printf("test_nogl end\n");
}


