#include <math.h>
#include <stdlib.h>
#include "SceneGraphRoot.h"
#include "MainLoop.h"
#include "SgRootChange.h"

static void ball_move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h);
static void ball_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h, SceneGraphPtr tree);
static void ball_collision_idle(SceneGraphPtr, void *sgroot_, int w, int h, SceneGraphPtr tree);


static float vy = 0.0f; // y 方向速度
static float dt = 1.0/1.0f; // frame rate 

static float e = -0.8f;  // 反発係数
static float g = 9.8f;  // 重力加速度
//static float v0 = 0.0f; // 初速は 0

static float h0; // 初期高さ
static float ball_radius = 100.0f;

static float speed = 10.0f;

static void
ball_move_idle2(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
    Pad *pad = sgroot->getController();

    if (pad->circle.isHold()) {
		if (pad->left.isHold()) {
			node->xyz[0] -= speed;
			if(node->xyz[0] < ball_radius)
				node->xyz[0] = ball_radius;
		} else if (pad->right.isHold()) {
			node->xyz[0] += speed;
			if(node->xyz[0] > screen_w  - ball_radius)
				node->xyz[0] = screen_w - ball_radius;
		}

		if (pad->up.isHold()) {
			node->xyz[1] -= speed;
		} else if (pad->down.isHold()) {
			node->xyz[1] += speed;
            if(node->xyz[1] > screen_h - ball_radius)
				node->xyz[1] = screen_h - ball_radius;
		}
    } else {
		node->set_move_collision(ball_move, ball_collision);
    }
}

static int time = 0;

static void
ball_move_idle(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
    SceneGraphRoot *sgroot = (SceneGraphRoot *)sgroot_;
    Pad *pad = sgroot->getController();

    if (pad->circle.isPush()) {
		node->set_move_collision(ball_move_idle2, ball_collision_idle);
		time = 0;
    }

    time++;

    if (time > 90) {
		float w = (float)random();
      
		w = fmodf(w, screen_w - ball_radius*2);
		node->xyz[0] = w + ball_radius;
		node->xyz[1] = h0;
		node->set_move_collision(ball_move, ball_collision);
		time = 0;
    }
}

static void
ball_move(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h)
{
    vy += g * dt;
    node->xyz[1] += vy * dt;
    //    node->xyz[0] += 10.0f;
}

static void
ball_collision_idle(SceneGraphPtr, void *sgroot_, int w, int h, SceneGraphPtr tree)
{
}

static void
ball_collision(SceneGraphPtr node, void *sgroot_, int screen_w, int screen_h,
			   SceneGraphPtr tree)
{
    if (node->xyz[1] > screen_h - ball_radius) {
		node->xyz[1] = screen_h - ball_radius;

		vy *= e;
		if (vy > -g && vy < 0) {
			vy = 0.0;
			node->set_move_collision(ball_move_idle, ball_collision_idle);
		}
    }
}

// prototype
MainLoopPtr 
SgRootChange::init(Viewer *viewer, int screen_w, int screen_h)
{    
    SgChange *sgroot = new SgChange(viewer);
    SceneGraphPtr ball;
    sgroot->run_init();
    srandom(100);

    sgroot->createFromXMLfile("xml_file/Ball.xml");
    ball = sgroot->createSceneGraph("Ball");
    ball->set_move_collision(ball_move, ball_collision);

    h0 = screen_h/2;
    h0 = -1000;

    ball->xyz[0] = screen_w/2;
    ball->xyz[1] = h0;
    ball->xyz[2] = 30.0f;

    sgroot->setSceneData(ball);

    return sgroot;
}

extern Application *
application() {
    return new SgRootChange();
}

const char *usr_help_str = "Usage: ./test_nogl [OPTION]\n";

extern int init(TaskManager *manager, int argc, char *argv[]);
extern void task_initialize();
static void TMend(TaskManager *manager);

int
TMmain(TaskManager *manager, int argc, char *argv[])
{
    task_initialize();
    manager->set_TMend(TMend);
    return init(manager, argc, argv);

}

void
TMend(TaskManager *manager)
{
    printf("test_nogl end\n");
}

/* end */
