#ifndef INCLUDED_VIEWER_TYPES
#define INCLUDED_VIEWER_TYPES

// texture は 8x8 に分割
// この値は、SpanPack にも使う
const int TEXTURE_SPLIT_PIXEL = 8;
const int TEXTURE_BLOCK_SIZE = TEXTURE_SPLIT_PIXEL*TEXTURE_SPLIT_PIXEL;

// 一個の SPE が描画担当する width, height (pixel)
const int split_screen_w = 256;
const int split_screen_h = 8;

enum video_type {
    VTYPE_SDL,
    VTYPE_FB,
    VTYPE_PS3,
    VTYPE_GL,
    VTYPE_NONE
};

#if defined(__LITTLE_ENDIAN__) 
const int redMask   = 0x0000ff00;
const int greenMask = 0x00ff0000;
const int blueMask  = 0xff000000;
const int alphaMask = 0x000000ff;
#else
const int redMask   = 0x00ff0000;
const int greenMask = 0x0000ff00;
const int blueMask  = 0x000000ff;
const int alphaMask = 0xff000000;
#endif

static inline int
getLocalPosition(int d, int offset)
{
    /**
     * offset が 2 の冪乗の時だけ使える。
     * 現在は offset は 2 の冪乗のみなので
     * これで問題ないけどどうなの？
     */
    return d & (offset-1);

    // offset が 2 の冪乗以外はこれにしないとだめ
    //return d % offset;
}

/**
 * ワールド座標における x の値を
 * split_screen_w で分割した領域(1 〜 split_screen_w)での座標に変換する
 * (ex. split_screen_w が 256 の場合、
 *      x =   1 -> 1
 *      x = 256 -> 256
 *      x = 257 -> 1
 */
static inline int
getLocalX(int x)
{
    return getLocalPosition(x, split_screen_w);
}

/**
 * getLocalX に同じ
 */
static inline int
getLocalY(int y)
{
    return getLocalPosition(y, split_screen_h);
}

#endif
